/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.common.web;

import com.atlassian.plugins.authentication.api.config.LoginGatewayType;
import com.atlassian.plugins.authentication.common.web.AlternateLoginPageUriProvider;
import com.atlassian.plugins.authentication.sso.util.TargetUrlNormalizer;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.auth.LoginUriProvider;
import java.net.URI;
import org.springframework.web.util.UriComponentsBuilder;

public class JiraAlternateLoginPageUriProvider
implements AlternateLoginPageUriProvider {
    private final LoginUriProvider loginUriProvider;
    private final ApplicationProperties applicationProperties;
    protected final TargetUrlNormalizer targetUrlNormalizer;

    public JiraAlternateLoginPageUriProvider(LoginUriProvider loginUriProvider, ApplicationProperties applicationProperties, TargetUrlNormalizer targetUrlNormalizer) {
        this.loginUriProvider = loginUriProvider;
        this.applicationProperties = applicationProperties;
        this.targetUrlNormalizer = targetUrlNormalizer;
    }

    @Override
    public String generateAlternateLoginPageUri(LoginGatewayType loginGatewayType, String destination) {
        URI normalizedDestinationUrl = this.targetUrlNormalizer.getRelativeTargetUrl(destination);
        return switch (loginGatewayType) {
            default -> throw new MatchException(null, null);
            case LoginGatewayType.GLOBAL_LOGIN_GATEWAY -> this.loginUriProvider.getLoginUri(normalizedDestinationUrl == null ? URI.create("") : normalizedDestinationUrl).toString();
            case LoginGatewayType.JSM_LOGIN_GATEWAY -> {
                UriComponentsBuilder alternateLoginPageUriBuilder = UriComponentsBuilder.fromUri((URI)URI.create(this.applicationProperties.getBaseUrl(UrlMode.RELATIVE))).path("/servicedesk/customer/login");
                if (normalizedDestinationUrl != null) {
                    alternateLoginPageUriBuilder.queryParam("destination", new Object[]{normalizedDestinationUrl.toString()});
                }
                yield alternateLoginPageUriBuilder.toUriString();
            }
        };
    }
}

