/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.encryption.db;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugins.authentication.encryption.db.model.SealedEntity;
import java.util.Optional;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class SealedEntitiesDao {
    private final ActiveObjects ao;

    public SealedEntitiesDao(ActiveObjects ao) {
        this.ao = ao;
    }

    public Optional<String> get(String identifier) {
        return (Optional)this.ao.executeInTransaction(() -> {
            SealedEntity[] sealedEntities = (SealedEntity[])this.ao.find(SealedEntity.class, Query.select().where("KEY = ?", new Object[]{identifier}));
            return sealedEntities.length == 0 ? Optional.empty() : Optional.of(sealedEntities[0].getValue());
        });
    }

    public void put(String identifier, String sealedSecret) {
        this.ao.executeInTransaction(() -> {
            SealedEntity[] sealedEntities = (SealedEntity[])this.ao.find(SealedEntity.class, Query.select().where("KEY = ?", new Object[]{identifier}));
            if (sealedEntities.length > 0) {
                this.ao.delete((RawEntity[])sealedEntities);
            }
            this.ao.create(SealedEntity.class, new DBParam[]{new DBParam("KEY", (Object)identifier), new DBParam("VALUE", (Object)sealedSecret)});
            return null;
        });
    }
}

