/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.cache;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.plugins.authentication.api.config.SsoConfig;
import com.atlassian.plugins.authentication.api.config.SsoConfigCachingService;
import com.atlassian.plugins.authentication.sso.config.SsoConfigDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HybridSsoConfigCache
implements SsoConfigCachingService {
    private static final Logger log = LoggerFactory.getLogger(HybridSsoConfigCache.class);
    private final CachedReference<SsoConfig> cachedSsoConfig;

    public HybridSsoConfigCache(CacheManager cacheManager, SsoConfigDao ssoConfigDao) {
        log.info("Initializing clustered SSO config cache");
        this.cachedSsoConfig = cacheManager.getCachedReference(HybridSsoConfigCache.class.getName(), (Supplier)new SsoConfigLoader(ssoConfigDao), this.getHybridCacheSettings());
    }

    public SsoConfig get() {
        return (SsoConfig)this.cachedSsoConfig.get();
    }

    public void reset() {
        log.info("Flushing SSO cache");
        this.cachedSsoConfig.reset();
    }

    private CacheSettings getHybridCacheSettings() {
        return new CacheSettingsBuilder().remote().replicateViaInvalidation().build();
    }

    private static class SsoConfigLoader
    implements Supplier<SsoConfig> {
        private final SsoConfigDao ssoConfigDao;

        SsoConfigLoader(SsoConfigDao ssoConfigDao) {
            this.ssoConfigDao = ssoConfigDao;
        }

        public SsoConfig get() {
            log.debug("Loading fresh SSO cache");
            return this.ssoConfigDao.getSsoConfig();
        }
    }
}

