/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.config;

import com.atlassian.plugins.authentication.api.config.SsoType;
import com.atlassian.plugins.authentication.sso.config.IdpConfigValidator;
import com.atlassian.plugins.authentication.sso.config.oidc.OidcConfigValidator;
import com.atlassian.plugins.authentication.sso.config.saml.SamlConfigValidator;
import jakarta.annotation.Nonnull;
import java.util.Optional;

public class IdpConfigValidatorProvider {
    private final SamlConfigValidator samlConfigValidator;
    private final OidcConfigValidator oidcConfigValidator;

    public IdpConfigValidatorProvider(SamlConfigValidator samlConfigValidator, OidcConfigValidator oidcConfigValidator) {
        this.samlConfigValidator = samlConfigValidator;
        this.oidcConfigValidator = oidcConfigValidator;
    }

    @Nonnull
    public Optional<IdpConfigValidator> getValidator(@Nonnull SsoType ssoType) {
        switch (ssoType) {
            case SAML: {
                return Optional.of(this.samlConfigValidator);
            }
            case OIDC: {
                return Optional.of(this.oidcConfigValidator);
            }
        }
        return Optional.empty();
    }

    @Nonnull
    public IdpConfigValidator getValidatorUnchecked(@Nonnull SsoType ssoType) {
        return this.getValidator(ssoType).orElseThrow(() -> new IllegalArgumentException("Could not obtain a validator for SSO type: " + String.valueOf(ssoType)));
    }
}

