/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.config;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.JiraUpgradedEvent;
import com.atlassian.plugins.authentication.api.config.SsoConfigService;
import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;
import com.atlassian.plugins.authentication.sso.config.PluginSettingsUtil;
import com.atlassian.plugins.authentication.sso.event.LoginFormToggledEvent;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraLoginGadgetDisabler
implements LifecycleAware {
    private static final Logger logger = LoggerFactory.getLogger(JiraLoginGadgetDisabler.class);
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)JiraLoginGadgetDisabler.class.getName());
    static final JobId JOB_ID = JobId.of((String)(JiraLoginGadgetDisabler.class.getName() + ":job"));
    public static final String PREFIX = "com.atlassian.plugins.authentication.sso.config.";
    public static final String LOGIN_GADGET_INITIALLY_DISABLED = "jira.login.gadget.initially.disabled";
    @VisibleForTesting
    static final Duration DEFAULT_INTERVAL = Duration.ofMinutes(15L);
    private final ApplicationProperties applicationProperties;
    private final EventPublisher eventPublisher;
    private final PluginSettingsFactory pluginSettings;
    private final SsoConfigService ssoConfigService;
    private final AuthenticationPluginFeatureInternalService authenticationPluginFeatureService;
    private final SchedulerService schedulerService;

    public JiraLoginGadgetDisabler(ApplicationProperties applicationProperties, EventPublisher eventPublisher, PluginSettingsFactory pluginSettings, SsoConfigService ssoConfigService, AuthenticationPluginFeatureInternalService authenticationPluginFeatureService, SchedulerService schedulerService) {
        this.applicationProperties = applicationProperties;
        this.eventPublisher = eventPublisher;
        this.pluginSettings = pluginSettings;
        this.ssoConfigService = ssoConfigService;
        this.authenticationPluginFeatureService = authenticationPluginFeatureService;
        this.schedulerService = schedulerService;
    }

    @PostConstruct
    public void setup() {
        this.eventPublisher.register((Object)this);
        try {
            this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, this::runJob);
            this.schedulerService.scheduleJob(JOB_ID, this.getJobConfig());
        }
        catch (SchedulerServiceException e) {
            String message = "Couldn't initialise scheduler for " + this.getClass().getName();
            logger.error(message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    @PreDestroy
    public void destroy() {
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
        this.eventPublisher.unregister((Object)this);
    }

    public void onStart() {
        if (this.is2SVCapableModeEnabled()) {
            logger.info("2SV capable mode is enabled. Jira login gadget should be disabled.");
            if (!this.applicationProperties.getOption("jira.disable.login.gadget")) {
                this.disableLoginGadget();
            }
        } else if (!this.ssoConfigService.getSsoConfig().getShowLoginForm()) {
            this.disableLoginGadget();
        } else {
            logger.info("Enabling Jira login gadget as the login form is available.");
            this.restoreLoginGadgetInitialState();
        }
    }

    public void onStop() {
    }

    @EventListener
    public void onLoginFormToggled(LoginFormToggledEvent event) {
        if (this.is2SVCapableModeEnabled()) {
            logger.info("2SV capable mode is enabled. Jira login gadget should be disabled.");
            if (!this.applicationProperties.getOption("jira.disable.login.gadget")) {
                this.disableLoginGadget();
            }
        } else if (event.isEnabled()) {
            logger.info("Enabling Jira login gadget as the login form is available.");
            this.restoreLoginGadgetInitialState();
        } else {
            this.disableLoginGadget();
        }
    }

    @EventListener
    public void onJiraUpgradedEvent(JiraUpgradedEvent jiraUpgradedEvent) {
        this.disableLoginGadgetIfLegacyModeIsDisabled();
    }

    @VisibleForTesting
    JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        this.disableLoginGadgetIfLegacyModeIsDisabled();
        return JobRunnerResponse.success();
    }

    private void disableLoginGadgetIfLegacyModeIsDisabled() {
        if (this.is2SVCapableModeEnabled() && !this.applicationProperties.getOption("jira.disable.login.gadget")) {
            logger.warn("2SV capable mode is enabled but the login gadget is not disabled. Disabling the gadget...");
            this.disableLoginGadget();
        }
    }

    private PluginSettings settings() {
        return this.pluginSettings.createGlobalSettings();
    }

    private void restoreLoginGadgetInitialState() {
        PluginSettingsUtil.getBooleanValue(this.settings(), LOGIN_GADGET_INITIALLY_DISABLED).ifPresent(loginGadgetInitiallyDisabled -> {
            this.applicationProperties.setOption("jira.disable.login.gadget", loginGadgetInitiallyDisabled.booleanValue());
            logger.info("Restored login gadget state to: {}", (Object)(loginGadgetInitiallyDisabled != false ? "disabled" : "enabled"));
        });
        this.settings().remove("com.atlassian.plugins.authentication.sso.config.jira.login.gadget.initially.disabled");
    }

    private void disableLoginGadget() {
        logger.info("Disabling Jira login gadget as the login form is disabled.");
        boolean loginGadgetInitiallyDisabled = PluginSettingsUtil.getBooleanValue(this.settings(), LOGIN_GADGET_INITIALLY_DISABLED).orElse(this.applicationProperties.getOption("jira.disable.login.gadget"));
        PluginSettingsUtil.setBooleanValue(this.settings(), LOGIN_GADGET_INITIALLY_DISABLED, loginGadgetInitiallyDisabled);
        this.applicationProperties.setOption("jira.disable.login.gadget", true);
        logger.info("Disabled login gadget. Initial state was: {}", (Object)(loginGadgetInitiallyDisabled ? "disabled" : "enabled"));
    }

    private boolean is2SVCapableModeEnabled() {
        return !this.authenticationPluginFeatureService.isLegacyModeEnabled();
    }

    private JobConfig getJobConfig() {
        Date when = Date.from(Instant.now().plus(15L, ChronoUnit.MINUTES));
        return JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)DEFAULT_INTERVAL.toMillis(), (Date)when));
    }
}

