/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.config;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.authentication.api.config.IdpConfigService;
import com.atlassian.plugins.authentication.api.config.IdpSearchParameters;
import com.atlassian.plugins.authentication.api.config.SsoConfig;
import com.atlassian.plugins.authentication.api.config.SsoConfigCachingService;
import com.atlassian.plugins.authentication.api.config.SsoConfigService;
import com.atlassian.plugins.authentication.api.config.ValidationError;
import com.atlassian.plugins.authentication.api.exception.CannotDisableLoginFormException;
import com.atlassian.plugins.authentication.api.exception.InvalidConfigException;
import com.atlassian.plugins.authentication.sso.config.SsoConfigDao;
import com.atlassian.plugins.authentication.sso.config.SsoConfigValidator;
import com.atlassian.plugins.authentication.sso.event.LoginFormToggledEvent;
import com.atlassian.plugins.authentication.sso.event.OidcDiscoveryRefreshCronUpdatedEvent;
import com.atlassian.plugins.authentication.sso.util.ApplicationStateValidator;
import com.atlassian.plugins.authentication.sso.util.ProductLicenseDataProvider;
import com.atlassian.plugins.authentication.util.MapMultimapUtil;
import com.google.common.collect.Multimap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SsoConfigServiceImpl
implements SsoConfigService {
    private final EventPublisher eventPublisher;
    private final SsoConfigDao ssoConfigDao;
    private final SsoConfigValidator ssoConfigValidator;
    private final IdpConfigService idpConfigService;
    private final ProductLicenseDataProvider productLicenseDataProvider;
    private final ApplicationStateValidator applicationStateValidator;
    private final SsoConfigCachingService ssoConfigCachingService;

    public SsoConfigServiceImpl(EventPublisher eventPublisher, SsoConfigDao ssoConfigDao, SsoConfigValidator ssoConfigValidator, IdpConfigService idpConfigService, ProductLicenseDataProvider productLicenseDataProvider, ApplicationStateValidator applicationStateValidator, SsoConfigCachingService ssoConfigCachingService) {
        this.eventPublisher = eventPublisher;
        this.ssoConfigDao = ssoConfigDao;
        this.ssoConfigValidator = ssoConfigValidator;
        this.idpConfigService = idpConfigService;
        this.productLicenseDataProvider = productLicenseDataProvider;
        this.applicationStateValidator = applicationStateValidator;
        this.ssoConfigCachingService = ssoConfigCachingService;
    }

    public SsoConfig getSsoConfig() {
        return this.ssoConfigDao.getSsoConfig();
    }

    public SsoConfig updateSsoConfig(@Nonnull SsoConfig newConfig) {
        Objects.requireNonNull(newConfig, "SSO configuration cannot be null");
        SsoConfig currentConfig = this.ssoConfigDao.getSsoConfig();
        this.validateSufficientLoginOptionsAreEnabled(newConfig, currentConfig);
        this.validateSufficientLoginOptionsForJsmAreEnabled(newConfig, currentConfig);
        SsoConfig newSsoConfig = this.updateSsoConfigInternal(currentConfig, newConfig);
        this.ssoConfigCachingService.reset();
        return newSsoConfig;
    }

    private void validateSufficientLoginOptionsAreEnabled(@Nonnull SsoConfig newConfig, SsoConfig currentConfig) {
        if (currentConfig.getShowLoginForm() && !newConfig.getShowLoginForm()) {
            List enabledIdpConfigs = this.idpConfigService.getIdpConfigs(IdpSearchParameters.allEnabled()).stream().filter(this.applicationStateValidator::canProcessAuthenticationRequest).collect(Collectors.toList());
            if (enabledIdpConfigs.size() < 1) {
                throw new CannotDisableLoginFormException("Can't disable login form");
            }
        }
    }

    private void validateSufficientLoginOptionsForJsmAreEnabled(@Nonnull SsoConfig newConfig, SsoConfig currentConfig) {
        List enabledIdpConfigs;
        if (this.productLicenseDataProvider.isServiceManagementProduct() && currentConfig.getShowLoginFormForJsm() && !newConfig.getShowLoginFormForJsm() && (enabledIdpConfigs = this.idpConfigService.getIdpConfigs(IdpSearchParameters.builder().setIncludeCustomerLoginsRestriction(Boolean.valueOf(true)).build())).size() < 1) {
            throw new CannotDisableLoginFormException("Can't disable login form for Jira Service Management");
        }
    }

    private SsoConfig updateSsoConfigInternal(@Nullable SsoConfig previousConfig, @Nonnull SsoConfig newConfig) {
        if (Objects.equals(newConfig, previousConfig)) {
            return previousConfig;
        }
        Multimap<String, ValidationError> errorsOnFields = this.ssoConfigValidator.validate(newConfig);
        if (!errorsOnFields.isEmpty()) {
            throw new InvalidConfigException(MapMultimapUtil.convertToMap(errorsOnFields));
        }
        this.publishEvents(previousConfig, newConfig);
        return this.ssoConfigDao.saveSsoConfig(newConfig);
    }

    private void publishEvents(SsoConfig previousConfig, SsoConfig newConfig) {
        if (previousConfig == null || previousConfig.getShowLoginForm() != newConfig.getShowLoginForm()) {
            this.eventPublisher.publish((Object)new LoginFormToggledEvent(newConfig.getShowLoginForm()));
        }
        if (previousConfig == null || !Objects.equals(previousConfig.getDiscoveryRefreshCron(), newConfig.getDiscoveryRefreshCron())) {
            this.eventPublisher.publish((Object)new OidcDiscoveryRefreshCronUpdatedEvent());
        }
    }

    public void resetConfig() {
        this.ssoConfigDao.removeSsoConfig();
        this.ssoConfigCachingService.reset();
        this.eventPublisher.publish((Object)new LoginFormToggledEvent(true));
    }
}

