/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.data;

import com.atlassian.plugins.authentication.sso.util.JsmUrlChecker;
import com.atlassian.plugins.authentication.sso.web.loginpage.ProductLoginPageData;
import com.atlassian.plugins.authentication.sso.web.loginpage.ProductLoginPageDataServiceFactory;
import com.atlassian.sal.api.ApplicationProperties;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;

public class LoginGatewayDataProvider {
    private static final String JSM_PLATFORM_ID = "jsm";
    private final ApplicationProperties applicationProperties;
    private final JsmUrlChecker jsmUrlChecker;
    private final ProductLoginPageDataServiceFactory productLoginPageDataServiceFactory;

    public LoginGatewayDataProvider(ApplicationProperties applicationProperties, JsmUrlChecker jsmUrlChecker, ProductLoginPageDataServiceFactory productLoginPageDataServiceFactory) {
        this.applicationProperties = applicationProperties;
        this.jsmUrlChecker = jsmUrlChecker;
        this.productLoginPageDataServiceFactory = productLoginPageDataServiceFactory;
    }

    public Map<String, Object> getMap(@Nonnull HttpServletRequest request, @Nonnull String refererUrl, @Nullable String destinationUrl) {
        ImmutableMap.Builder dataBuilder = ImmutableMap.builder().put((Object)"product", (Object)this.getProductId(refererUrl));
        if (destinationUrl != null) {
            dataBuilder.put((Object)"destination", (Object)destinationUrl);
        }
        ProductLoginPageData productLoginPageData = this.productLoginPageDataServiceFactory.getProductLoginPageDataService(refererUrl).getLoginPageData(request);
        productLoginPageData.getForgotLoginDetailsUrl().ifPresent(url -> dataBuilder.put((Object)"forgotLoginDetailsUrl", url));
        productLoginPageData.getForgotPasswordUrl().ifPresent(url -> dataBuilder.put((Object)"forgotPasswordUrl", url));
        productLoginPageData.getChangeExpiredPasswordUrl().ifPresent(url -> dataBuilder.put((Object)"changeExpiredPasswordUrl", url));
        productLoginPageData.getSignupUrl().ifPresent(url -> dataBuilder.put((Object)"signupUrl", url));
        productLoginPageData.getRecoveryModeContext().ifPresent(recoveryModeContext -> dataBuilder.put((Object)"recoveryModeContext", recoveryModeContext));
        productLoginPageData.getCustomLogoUrl().ifPresent(url -> dataBuilder.put((Object)"customLogoUrl", url));
        productLoginPageData.getCustomBannerImageUrl().ifPresent(url -> dataBuilder.put((Object)"customBannerImageUrl", url));
        productLoginPageData.getCustomBannerBackgroundColor().ifPresent(color -> dataBuilder.put((Object)"customBannerBackgroundColor", color));
        productLoginPageData.getCustomButtonBackgroundColor().ifPresent(color -> dataBuilder.put((Object)"customButtonBackgroundColor", color));
        productLoginPageData.getCustomButtonTextColor().ifPresent(color -> dataBuilder.put((Object)"customButtonTextColor", color));
        productLoginPageData.getCustomAnnouncementSubject().ifPresent(subject -> dataBuilder.put((Object)"customAnnouncementSubject", subject));
        productLoginPageData.getCustomAnnouncementMessage().ifPresent(message -> dataBuilder.put((Object)"customAnnouncementMessage", message));
        productLoginPageData.getPermissionsViolationContext().ifPresent(user -> dataBuilder.put((Object)"permissionsViolationContext", user));
        productLoginPageData.getContactAdminLink().ifPresent(contactLink -> dataBuilder.put((Object)"contactAdminLink", contactLink));
        productLoginPageData.getLanguageContext().ifPresent(languages -> dataBuilder.put((Object)"languageContext", languages));
        productLoginPageData.getPrefilledUsername().ifPresent(predefinedUsername -> dataBuilder.put((Object)"prefilledUsername", predefinedUsername));
        productLoginPageData.getAdditionalSuccessMessage().ifPresent(predefinedLoginSuccessMessage -> dataBuilder.put((Object)"additionalSuccessMessage", predefinedLoginSuccessMessage));
        productLoginPageData.getLoginHeader().ifPresent(loginHeader -> dataBuilder.put((Object)"loginHeader", loginHeader));
        productLoginPageData.getLoginText().ifPresent(loginText -> dataBuilder.put((Object)"loginText", loginText));
        dataBuilder.put((Object)"hideHeader", (Object)productLoginPageData.isHideHeader());
        dataBuilder.put((Object)"rememberMeType", (Object)productLoginPageData.getRememberMeType());
        dataBuilder.put((Object)"showLogo", (Object)productLoginPageData.isShowLogo());
        dataBuilder.put((Object)"authenticationByEmail", (Object)productLoginPageData.isAuthenticationByEmail());
        return dataBuilder.build();
    }

    private String getProductId(String refererUrl) {
        return this.jsmUrlChecker.isJsmRequest(refererUrl) ? JSM_PLATFORM_ID : this.applicationProperties.getPlatformId();
    }
}

