/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.license;

import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import com.atlassian.plugins.authentication.sso.license.ProductLicenseChecker;
import java.util.Set;

public class BitbucketLicenseChecker
implements ProductLicenseChecker {
    private final LicenseService licenseService;

    public BitbucketLicenseChecker(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    @Override
    public boolean areSlotsAvailable(Set<String> groupNames) {
        BitbucketServerLicense license = this.licenseService.get();
        if (license == null) {
            return false;
        }
        if (license.isUnlimitedNumberOfUsers()) {
            return true;
        }
        return this.licenseService.getLicensedUsersCount() < license.getMaximumNumberOfUsers();
    }
}

