/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.license;

import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.license.exception.LicenseException;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.plugins.authentication.sso.license.ProductLicenseChecker;
import java.util.Set;

public class ConfluenceLicenseChecker
implements ProductLicenseChecker {
    private final LicenseService licenseService;
    private final UserChecker userChecker;

    public ConfluenceLicenseChecker(LicenseService licenseService, UserChecker userChecker) {
        this.licenseService = licenseService;
        this.userChecker = userChecker;
    }

    @Override
    public boolean areSlotsAvailable(Set<String> groupNames) {
        try {
            ConfluenceLicense license = this.licenseService.retrieve();
            if (license.isUnlimitedNumberOfUsers()) {
                return true;
            }
            return this.userChecker.getNumberOfRegisteredUsers() < license.getMaximumNumberOfUsers();
        }
        catch (LicenseException e) {
            return false;
        }
    }
}

