/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.option;

import com.atlassian.plugins.authentication.api.config.IdpConfig;
import com.atlassian.plugins.authentication.api.config.LoginGatewayType;
import com.atlassian.plugins.authentication.api.config.LoginOptionsService;
import com.atlassian.plugins.authentication.common.web.AlternateLoginPageUriProvider;
import com.atlassian.plugins.authentication.sso.option.ProductLoginOptionChecker;
import com.atlassian.plugins.authentication.sso.util.ProductLicenseDataProvider;
import com.atlassian.plugins.authentication.sso.web.usercontext.IdpNotApplicableException;
import com.atlassian.plugins.authentication.tsv.exception.LoginFormNotApplicableException;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraLoginOptionChecker
implements ProductLoginOptionChecker {
    private static final Logger log = LoggerFactory.getLogger(JiraLoginOptionChecker.class);
    private final UserManager userManager;
    private final AlternateLoginPageUriProvider alternateLoginPageUriProvider;
    private final LoginOptionsService loginOptionsService;
    private final ProductLicenseDataProvider productLicenseDataProvider;

    public JiraLoginOptionChecker(UserManager userManager, AlternateLoginPageUriProvider alternateLoginPageUriProvider, LoginOptionsService loginOptionsService, ProductLicenseDataProvider productLicenseDataProvider) {
        this.userManager = userManager;
        this.alternateLoginPageUriProvider = alternateLoginPageUriProvider;
        this.loginOptionsService = loginOptionsService;
        this.productLicenseDataProvider = productLicenseDataProvider;
    }

    @Override
    public boolean isLoginFormLoginPossible() {
        List loginOptions = this.loginOptionsService.getLoginOptions(true, this.resolveLoginGatewayTypes());
        return this.hasLoginFormLoginOption(loginOptions);
    }

    private Set<LoginGatewayType> resolveLoginGatewayTypes() {
        ImmutableSet.Builder loginGatewaysBuilder = ImmutableSet.builder().add((Object)LoginGatewayType.GLOBAL_LOGIN_GATEWAY);
        if (this.productLicenseDataProvider.isServiceManagementProduct()) {
            loginGatewaysBuilder.add((Object)LoginGatewayType.JSM_LOGIN_GATEWAY);
        }
        return loginGatewaysBuilder.build();
    }

    @Override
    public void checkLoginFormOptionApplicable(UserKey userKey, String destination) throws LoginFormNotApplicableException {
        boolean isUserLicensed = this.userManager.isLicensed(userKey);
        LoginGatewayType loginGatewayForUser = isUserLicensed ? LoginGatewayType.GLOBAL_LOGIN_GATEWAY : LoginGatewayType.JSM_LOGIN_GATEWAY;
        List appropriateLoginOptionsForUser = this.loginOptionsService.getLoginOptions(true, loginGatewayForUser);
        if (!this.hasLoginFormLoginOption(appropriateLoginOptionsForUser)) {
            log.debug("User {} attempted login with login form which is disabled on login gateway {}", (Object)userKey.getStringValue(), (Object)loginGatewayForUser);
            String alternativeLoginUrl = this.alternateLoginPageUriProvider.generateAlternateLoginPageUri(loginGatewayForUser, destination);
            throw new LoginFormNotApplicableException(alternativeLoginUrl);
        }
    }

    @Override
    public void checkIdpLoginOptionApplicable(@Nonnull String username, @Nonnull IdpConfig idpConfig, @Nonnull String destination) {
        boolean isIdpInapplicable;
        UserProfile userProfile = this.userManager.getUserProfile(username);
        Objects.requireNonNull(userProfile);
        boolean isUserLicensed = this.userManager.isLicensed(userProfile.getUserKey());
        boolean bl = isIdpInapplicable = isUserLicensed ? this.isIdpInapplicableForJiraUser(idpConfig) : this.isIdpInapplicableForJsmUser(idpConfig);
        if (isIdpInapplicable) {
            throw new IdpNotApplicableException("User " + username + " is not allowed to login with IDP " + idpConfig.getId(), this.alternateLoginPageUriProvider.generateAlternateLoginPageUri(isUserLicensed ? LoginGatewayType.GLOBAL_LOGIN_GATEWAY : LoginGatewayType.JSM_LOGIN_GATEWAY, destination));
        }
    }

    private boolean isIdpInapplicableForJiraUser(IdpConfig idpConfig) {
        return !idpConfig.isEnabled();
    }

    private boolean isIdpInapplicableForJsmUser(IdpConfig idpConfig) {
        return !idpConfig.isIncludeCustomerLogins();
    }
}

