/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.rest;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.dc.swagger.annotations.BasePathDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;
import com.atlassian.plugins.authentication.sso.rest.model.KeyCertificatePair;
import com.atlassian.plugins.authentication.sso.web.saml.certificate.SamlSpKeyCertificatePairService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@SystemAdminOnly
@Path(value="/saml/certificate")
@BasePathDoc(value="/authconfig/latest")
@Tag(name="SAML certificate configuration")
public class SamlCertificateResource {
    private final SamlSpKeyCertificatePairService samlSpKeyCertificatePairService;
    private final AuthenticationPluginFeatureInternalService authenticationPluginFeatureInternalService;

    @Inject
    public SamlCertificateResource(SamlSpKeyCertificatePairService samlSpKeyCertificatePairService, AuthenticationPluginFeatureInternalService authenticationPluginFeatureInternalService) {
        this.samlSpKeyCertificatePairService = samlSpKeyCertificatePairService;
        this.authenticationPluginFeatureInternalService = authenticationPluginFeatureInternalService;
    }

    @Operation(description="returns the currently used certificate for signing SAML authentication requests")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Currently used certificate in PEM format")})
    @GET
    @Produces(value={"text/plain"})
    public Response getSamlCertificate() {
        if (!this.authenticationPluginFeatureInternalService.isSamlAuthRequestsSigningEnabled()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        KeyCertificatePair keyCertificatePair = this.samlSpKeyCertificatePairService.getKeyCertificatePair();
        return Response.ok((Object)keyCertificatePair.getCertificateAsPemString()).header("Content-Disposition", (Object)"attachment; filename=certificate.pem").build();
    }

    @Operation(description="generates a new certificate for signing SAML authentication requests")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="The new certificate in PEM format")})
    @POST
    @Path(value="/reset")
    @Produces(value={"text/plain"})
    public Response regenerateCertificate() {
        if (!this.authenticationPluginFeatureInternalService.isSamlAuthRequestsSigningEnabled()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        KeyCertificatePair keyCertificatePair = this.samlSpKeyCertificatePairService.generateCertificateAndPrivateKey();
        return Response.ok((Object)keyCertificatePair.getCertificateAsPemString()).header("Content-Disposition", (Object)"attachment; filename=certificate.pem").build();
    }
}

