/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.rest;

import com.atlassian.plugins.authentication.api.config.ImmutableSsoConfig;
import com.atlassian.plugins.authentication.api.config.SsoConfig;
import com.atlassian.plugins.authentication.api.config.SsoConfigService;
import com.atlassian.plugins.authentication.sso.rest.model.SsoConfigEntity;
import jakarta.annotation.Nonnull;
import java.util.function.Consumer;

public class SsoConfigResourceService {
    private final SsoConfigService configService;

    public SsoConfigResourceService(SsoConfigService configService) {
        this.configService = configService;
    }

    @Nonnull
    public SsoConfigEntity getConfig() {
        return new SsoConfigEntity(this.configService.getSsoConfig());
    }

    @Nonnull
    public SsoConfigEntity updateConfig(@Nonnull SsoConfigEntity entity) {
        ImmutableSsoConfig configToStore = this.buildConfig(entity);
        SsoConfig updatedConfig = this.configService.updateSsoConfig((SsoConfig)configToStore);
        return new SsoConfigEntity(updatedConfig);
    }

    private ImmutableSsoConfig buildConfig(SsoConfigEntity entity) {
        SsoConfig currentConfig = this.configService.getSsoConfig();
        ImmutableSsoConfig.Builder configBuilder = ImmutableSsoConfig.toBuilder((SsoConfig)currentConfig);
        this.updateGenericConfig(configBuilder, entity);
        return configBuilder.build();
    }

    private void updateGenericConfig(@Nonnull ImmutableSsoConfig.Builder builder, @Nonnull SsoConfigEntity entity) {
        this.setIfNonNull(entity.getShowLoginForm(), arg_0 -> ((ImmutableSsoConfig.Builder)builder).setShowLoginForm(arg_0));
        this.setIfNonNull(entity.getDiscoveryRefreshCron(), arg_0 -> ((ImmutableSsoConfig.Builder)builder).setDiscoveryRefreshCron(arg_0));
        this.setIfNonNull(entity.getEnableAuthenticationFallback(), arg_0 -> ((ImmutableSsoConfig.Builder)builder).setEnableAuthenticationFallback(arg_0));
        this.setIfNonNull(entity.getShowLoginFormForJsm(), arg_0 -> ((ImmutableSsoConfig.Builder)builder).setShowLoginFormForJsm(arg_0));
    }

    private <T> void setIfNonNull(T value, Consumer<T> setter) {
        if (value != null) {
            setter.accept(value);
        }
    }
}

