/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.rest.model;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public record KeyCertificatePair(PrivateKey privateKey, X509Certificate certificate) implements Serializable
{
    /*
     * Enabled aggressive exception aggregation
     */
    public String getCertificateAsPemString() {
        try (StringWriter writer = new StringWriter();){
            String string;
            try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);){
                pemWriter.writeObject((Object)this.certificate);
                pemWriter.flush();
                string = writer.toString();
            }
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert certificate to a PEM string.", e);
        }
    }
}

