/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.spring;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.security.BambooCaptchaValidationService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.authentication.api.config.LoginOptionsService;
import com.atlassian.plugins.authentication.common.analytics.NodeIdProvider;
import com.atlassian.plugins.authentication.common.analytics.product.BambooNodeIdProvider;
import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;
import com.atlassian.plugins.authentication.common.properties.SystemPropertyBasedAuthenticationPluginFeatureService;
import com.atlassian.plugins.authentication.common.properties.bamboo.BambooAuthenticationPluginFeatureService;
import com.atlassian.plugins.authentication.common.spring.CommonImportsConfiguration;
import com.atlassian.plugins.authentication.common.web.AlternateLoginPageUriProvider;
import com.atlassian.plugins.authentication.common.web.DefaultAlternateLoginPageUriProvider;
import com.atlassian.plugins.authentication.common.web.loopsprevention.RedirectsLoopPreventer;
import com.atlassian.plugins.authentication.common.web.loopsprevention.SeraphRedirectsLoopPreventer;
import com.atlassian.plugins.authentication.sso.config.BambooSignupDisabler;
import com.atlassian.plugins.authentication.sso.johnson.DefaultJohnsonChecker;
import com.atlassian.plugins.authentication.sso.johnson.JohnsonChecker;
import com.atlassian.plugins.authentication.sso.license.BambooLicenseChecker;
import com.atlassian.plugins.authentication.sso.license.ProductLicenseChecker;
import com.atlassian.plugins.authentication.sso.option.DefaultLoginOptionChecker;
import com.atlassian.plugins.authentication.sso.option.ProductLoginOptionChecker;
import com.atlassian.plugins.authentication.sso.spring.BambooImportsConfiguration;
import com.atlassian.plugins.authentication.sso.util.DefaultLegacyAuthenticationMethodsDataProvider;
import com.atlassian.plugins.authentication.sso.util.LegacyAuthenticationMethodsDataProvider;
import com.atlassian.plugins.authentication.sso.util.TargetUrlNormalizer;
import com.atlassian.plugins.authentication.sso.web.BambooPostAuthenticationProcessor;
import com.atlassian.plugins.authentication.sso.web.GuavaSessionDataCacheFactory;
import com.atlassian.plugins.authentication.sso.web.PostAuthenticationProcessor;
import com.atlassian.plugins.authentication.sso.web.SessionDataCacheFactory;
import com.atlassian.plugins.authentication.sso.web.loginpage.BambooProductLoginPageDataService;
import com.atlassian.plugins.authentication.sso.web.loginpage.ProductLoginPageDataService;
import com.atlassian.plugins.authentication.sso.web.loginpage.ProductLoginPageDataServiceFactory;
import com.atlassian.plugins.authentication.sso.web.loginpage.SingleApplicationProductLoginPageDataServiceFactory;
import com.atlassian.plugins.authentication.sso.web.usercontext.impl.jit.DirectoryQueryJitDirectoriesFinder;
import com.atlassian.plugins.authentication.sso.web.usercontext.impl.jit.JitDirectoriesFinder;
import com.atlassian.plugins.authentication.sso.web.usercontext.rememberme.RememberMeCookieHandler;
import com.atlassian.plugins.authentication.sso.web.usercontext.rememberme.SeraphRememberMeCookieHandler;
import com.atlassian.plugins.authentication.tsv.db.TotpUserEnrollmentDao;
import com.atlassian.plugins.authentication.tsv.service.BambooTotpIssuerService;
import com.atlassian.plugins.authentication.tsv.service.DefaultEnrollmentCleanupService;
import com.atlassian.plugins.authentication.tsv.service.EnrollmentCleanupService;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.AuthenticationFailedResponseBuilder;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.resultextractor.NoOpSeraphLoginResultExtractor;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.resultextractor.SeraphLoginResultExtractor;
import com.atlassian.plugins.authentication.tsv.service.responsebuilder.DefaultAuthenticationFailedResponseBuilder;
import com.atlassian.plugins.authentication.tsv.service.session.AuthenticatedSessionCreator;
import com.atlassian.plugins.authentication.tsv.service.session.EmbeddedCrowdAuthenticatedSessionCreator;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.BambooOnly;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={BambooImportsConfiguration.class, CommonImportsConfiguration.class})
@Conditional(value={BambooOnly.class})
public class BambooSsoConfiguration {
    @Bean
    public ProductLoginOptionChecker productLoginOptionChecker(LoginOptionsService loginOptionsService) {
        return new DefaultLoginOptionChecker(loginOptionsService);
    }

    @Bean
    public NodeIdProvider nodeIdProvider() {
        return new BambooNodeIdProvider();
    }

    @Bean
    public SessionDataCacheFactory sessionDataCacheFactory() {
        return new GuavaSessionDataCacheFactory();
    }

    @Bean
    public ProductLicenseChecker productLicenseChecker() {
        return new BambooLicenseChecker();
    }

    @Bean
    public JitDirectoriesFinder jitDirectoriesFinder(DirectoryManager directoryManager) {
        return new DirectoryQueryJitDirectoriesFinder(directoryManager);
    }

    @Bean
    public LegacyAuthenticationMethodsDataProvider legacyAuthenticationMethodsDataProvider() {
        return new DefaultLegacyAuthenticationMethodsDataProvider();
    }

    @Bean
    public RememberMeCookieHandler rememberMeCookieHandler() {
        return new SeraphRememberMeCookieHandler();
    }

    @Bean
    public RedirectsLoopPreventer redirectsLoopPreventer() {
        return new SeraphRedirectsLoopPreventer();
    }

    @Bean
    public BambooSignupDisabler bambooSignupDisabler(AdministrationConfigurationAccessor administrationConfigurationAccessor, EventPublisher eventPublisher, PluginSettingsFactory pluginSettings) {
        return new BambooSignupDisabler(administrationConfigurationAccessor, eventPublisher, pluginSettings);
    }

    @Bean
    public JohnsonChecker johnsonChecker() {
        return new DefaultJohnsonChecker();
    }

    @Bean
    public ProductLoginPageDataService loginPageDataService(AdministrationConfigurationAccessor administrationConfigurationAccessor, ApplicationProperties applicationProperties) {
        return new BambooProductLoginPageDataService(administrationConfigurationAccessor, applicationProperties);
    }

    @Bean
    public ProductLoginPageDataServiceFactory productLoginPageDataServiceFactory(ProductLoginPageDataService productLoginPageDataService) {
        return new SingleApplicationProductLoginPageDataServiceFactory(productLoginPageDataService);
    }

    @Bean
    public BambooTotpIssuerService bambooTotpIssuerService(ApplicationProperties salApplicationProperties, AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        return new BambooTotpIssuerService(salApplicationProperties, administrationConfigurationAccessor);
    }

    @Bean
    public AlternateLoginPageUriProvider alternateLoginPageUriProvider(LoginUriProvider loginUriProvider, TargetUrlNormalizer targetUrlNormalizer) {
        return new DefaultAlternateLoginPageUriProvider(loginUriProvider, targetUrlNormalizer);
    }

    @Bean
    public AuthenticationPluginFeatureInternalService authenticationPluginFeatureService() {
        return new BambooAuthenticationPluginFeatureService(new SystemPropertyBasedAuthenticationPluginFeatureService());
    }

    @Bean
    public EnrollmentCleanupService enrollmentCleanupService(TotpUserEnrollmentDao totpUserEnrollmentDao, UserManager userManager) {
        return new DefaultEnrollmentCleanupService(totpUserEnrollmentDao, userManager);
    }

    @Bean
    public PostAuthenticationProcessor postAuthenticationProcessor(BambooCaptchaValidationService bambooCaptchaValidationService) {
        return new BambooPostAuthenticationProcessor(bambooCaptchaValidationService);
    }

    @Bean
    public AuthenticationFailedResponseBuilder authenticationFailedResponseBuilder(I18nResolver i18nResolver) {
        return new DefaultAuthenticationFailedResponseBuilder(i18nResolver);
    }

    @Bean
    public AuthenticatedSessionCreator authenticatedSessionCreator(AuthenticationListener authenticationListener, I18nResolver i18nResolver) {
        return new EmbeddedCrowdAuthenticatedSessionCreator(authenticationListener, i18nResolver);
    }

    @Bean
    public SeraphLoginResultExtractor seraphLoginReasonExtractor() {
        return new NoOpSeraphLoginResultExtractor();
    }
}

