/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.spring;

import com.atlassian.bitbucket.auth.AuthenticationService;
import com.atlassian.bitbucket.auth.RememberMeService;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.cache.CacheManager;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelper;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelperImpl;
import com.atlassian.crowd.integration.http.util.CrowdHttpValidationFactorExtractor;
import com.atlassian.crowd.integration.http.util.CrowdHttpValidationFactorExtractorImpl;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.plugins.authentication.api.config.LoginOptionsService;
import com.atlassian.plugins.authentication.common.analytics.NodeIdProvider;
import com.atlassian.plugins.authentication.common.analytics.product.BitbucketNodeIdProvider;
import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;
import com.atlassian.plugins.authentication.common.properties.bitbucket.BitbucketAuthenticationPluginFeatureService;
import com.atlassian.plugins.authentication.common.web.AlternateLoginPageUriProvider;
import com.atlassian.plugins.authentication.common.web.DefaultAlternateLoginPageUriProvider;
import com.atlassian.plugins.authentication.common.web.loopsprevention.NoopRedirectsLoopPreventer;
import com.atlassian.plugins.authentication.common.web.loopsprevention.RedirectsLoopPreventer;
import com.atlassian.plugins.authentication.sso.johnson.DefaultJohnsonChecker;
import com.atlassian.plugins.authentication.sso.johnson.JohnsonChecker;
import com.atlassian.plugins.authentication.sso.license.BitbucketLicenseChecker;
import com.atlassian.plugins.authentication.sso.license.ProductLicenseChecker;
import com.atlassian.plugins.authentication.sso.option.DefaultLoginOptionChecker;
import com.atlassian.plugins.authentication.sso.option.ProductLoginOptionChecker;
import com.atlassian.plugins.authentication.sso.spring.BitbucketImportsConfiguration;
import com.atlassian.plugins.authentication.sso.util.DefaultLegacyAuthenticationMethodsDataProvider;
import com.atlassian.plugins.authentication.sso.util.LegacyAuthenticationMethodsDataProvider;
import com.atlassian.plugins.authentication.sso.util.TargetUrlNormalizer;
import com.atlassian.plugins.authentication.sso.web.AtlassianCacheReplicatedSessionDataCacheFactory;
import com.atlassian.plugins.authentication.sso.web.NoOpPostAuthenticationProcessor;
import com.atlassian.plugins.authentication.sso.web.PostAuthenticationProcessor;
import com.atlassian.plugins.authentication.sso.web.SessionDataCacheFactory;
import com.atlassian.plugins.authentication.sso.web.filter.loginform.checker.JAuthForcedNativeLoginCredentialsBlockRequestChecker;
import com.atlassian.plugins.authentication.sso.web.loginpage.BitbucketProductLoginPageDataService;
import com.atlassian.plugins.authentication.sso.web.loginpage.ProductLoginPageDataService;
import com.atlassian.plugins.authentication.sso.web.loginpage.ProductLoginPageDataServiceFactory;
import com.atlassian.plugins.authentication.sso.web.loginpage.SingleApplicationProductLoginPageDataServiceFactory;
import com.atlassian.plugins.authentication.sso.web.usercontext.impl.jit.DirectoryQueryJitDirectoriesFinder;
import com.atlassian.plugins.authentication.sso.web.usercontext.impl.jit.JitDirectoriesFinder;
import com.atlassian.plugins.authentication.sso.web.usercontext.rememberme.BitbucketRememberMeCookieHandler;
import com.atlassian.plugins.authentication.sso.web.usercontext.rememberme.RememberMeCookieHandler;
import com.atlassian.plugins.authentication.tsv.db.TotpUserEnrollmentDao;
import com.atlassian.plugins.authentication.tsv.service.BitbucketTotpIssuerService;
import com.atlassian.plugins.authentication.tsv.service.DefaultEnrollmentCleanupService;
import com.atlassian.plugins.authentication.tsv.service.EnrollmentCleanupService;
import com.atlassian.plugins.authentication.tsv.service.TotpIssuerService;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.AuthenticationFailedResponseBuilder;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.BitbucketCredentialVerificationService;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.CredentialVerificationService;
import com.atlassian.plugins.authentication.tsv.service.responsebuilder.BitbucketAuthenticationFailedResponseBuilder;
import com.atlassian.plugins.authentication.tsv.service.session.AuthenticatedSessionCreator;
import com.atlassian.plugins.authentication.tsv.service.session.EmbeddedCrowdAuthenticatedSessionCreator;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.BitbucketOnly;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={BitbucketImportsConfiguration.class})
@Conditional(value={BitbucketOnly.class})
public class BitbucketSsoConfiguration {
    @Bean
    public ProductLoginOptionChecker productLoginOptionChecker(LoginOptionsService loginOptionsService) {
        return new DefaultLoginOptionChecker(loginOptionsService);
    }

    @Bean
    public NodeIdProvider nodeIdProvider(ClusterService clusterService) {
        return new BitbucketNodeIdProvider(clusterService);
    }

    @Bean
    public SessionDataCacheFactory sessionDataCacheFactory(CacheManager cacheManager) {
        return new AtlassianCacheReplicatedSessionDataCacheFactory(cacheManager);
    }

    @Bean
    public ProductLicenseChecker productLicenseChecker(LicenseService licenseService) {
        return new BitbucketLicenseChecker(licenseService);
    }

    @Bean
    public JitDirectoriesFinder jitDirectoriesFinder(DirectoryManager directoryManager) {
        return new DirectoryQueryJitDirectoriesFinder(directoryManager);
    }

    @Bean
    public LegacyAuthenticationMethodsDataProvider legacyAuthenticationMethodsDataProvider() {
        return new DefaultLegacyAuthenticationMethodsDataProvider();
    }

    @Bean
    public RememberMeCookieHandler rememberMeCookieHandler(RememberMeService rememberMeService) {
        return new BitbucketRememberMeCookieHandler(rememberMeService);
    }

    @Bean
    public RedirectsLoopPreventer redirectsLoopPreventer() {
        return new NoopRedirectsLoopPreventer();
    }

    @Bean
    public JohnsonChecker johnsonChecker() {
        return new DefaultJohnsonChecker();
    }

    @Bean
    public ProductLoginPageDataService loginPageDataService(ApplicationPropertiesService propertiesService, ApplicationProperties salApplicationProperties) {
        return new BitbucketProductLoginPageDataService(propertiesService, salApplicationProperties);
    }

    @Bean
    public ProductLoginPageDataServiceFactory productLoginPageDataServiceFactory(ProductLoginPageDataService productLoginPageDataService) {
        return new SingleApplicationProductLoginPageDataServiceFactory(productLoginPageDataService);
    }

    @Bean
    public TotpIssuerService bitbucketTotpIssuerService(ApplicationProperties salApplicationProperties, ApplicationPropertiesService applicationPropertiesService) {
        return new BitbucketTotpIssuerService(salApplicationProperties, applicationPropertiesService);
    }

    @Bean
    public CrowdHttpTokenHelper crowdHttpTokenHelper() {
        return CrowdHttpTokenHelperImpl.getInstance((CrowdHttpValidationFactorExtractor)CrowdHttpValidationFactorExtractorImpl.getInstance());
    }

    @Bean
    public CredentialVerificationService credentialVerificationService(AuthenticationService bitbucketAuthService, PermissionService permissionService, UserManager userManager, CrowdHttpTokenHelper crowdHttpTokenHelper) {
        return new BitbucketCredentialVerificationService(bitbucketAuthService, permissionService, userManager, crowdHttpTokenHelper);
    }

    @Bean
    public AlternateLoginPageUriProvider alternateLoginPageUriProvider(LoginUriProvider loginUriProvider, TargetUrlNormalizer targetUrlNormalizer) {
        return new DefaultAlternateLoginPageUriProvider(loginUriProvider, targetUrlNormalizer);
    }

    @Bean
    public AuthenticationPluginFeatureInternalService authenticationPluginFeatureService() {
        return new BitbucketAuthenticationPluginFeatureService();
    }

    @Bean
    public EnrollmentCleanupService enrollmentCleanupService(TotpUserEnrollmentDao totpUserEnrollmentDao, UserManager userManager) {
        return new DefaultEnrollmentCleanupService(totpUserEnrollmentDao, userManager);
    }

    @Bean
    public PostAuthenticationProcessor postAuthenticationProcessor() {
        return new NoOpPostAuthenticationProcessor();
    }

    @Bean
    public AuthenticationFailedResponseBuilder authenticationFailedResponseBuilder(I18nResolver i18nResolver) {
        return new BitbucketAuthenticationFailedResponseBuilder(i18nResolver);
    }

    @Bean
    public AuthenticatedSessionCreator authenticatedSessionCreator(AuthenticationListener authenticationListener, I18nResolver i18nResolver) {
        return new EmbeddedCrowdAuthenticatedSessionCreator(authenticationListener, i18nResolver);
    }

    @Bean
    public JAuthForcedNativeLoginCredentialsBlockRequestChecker jAuthForcedNativeLoginCredentialsBlockRequestChecker() {
        return new JAuthForcedNativeLoginCredentialsBlockRequestChecker();
    }
}

