/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.spring;

import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.plugins.authentication.api.config.LoginOptionsService;
import com.atlassian.plugins.authentication.common.analytics.NodeIdProvider;
import com.atlassian.plugins.authentication.common.analytics.product.ConfluenceNodeIdProvider;
import com.atlassian.plugins.authentication.common.spring.CommonImportsConfiguration;
import com.atlassian.plugins.authentication.common.web.AlternateLoginPageUriProvider;
import com.atlassian.plugins.authentication.common.web.DefaultAlternateLoginPageUriProvider;
import com.atlassian.plugins.authentication.common.web.loopsprevention.RedirectsLoopPreventer;
import com.atlassian.plugins.authentication.common.web.loopsprevention.SeraphRedirectsLoopPreventer;
import com.atlassian.plugins.authentication.sso.johnson.JohnsonChecker;
import com.atlassian.plugins.authentication.sso.johnson.JohnsonSkippedJohnsonChecker;
import com.atlassian.plugins.authentication.sso.license.ConfluenceLicenseChecker;
import com.atlassian.plugins.authentication.sso.license.ProductLicenseChecker;
import com.atlassian.plugins.authentication.sso.option.DefaultLoginOptionChecker;
import com.atlassian.plugins.authentication.sso.option.ProductLoginOptionChecker;
import com.atlassian.plugins.authentication.sso.spring.ConfluenceImportConfiguration;
import com.atlassian.plugins.authentication.sso.util.ConfluenceLegacyAuthenticationMethodsDataProvider;
import com.atlassian.plugins.authentication.sso.util.LegacyAuthenticationMethodsDataProvider;
import com.atlassian.plugins.authentication.sso.util.TargetUrlNormalizer;
import com.atlassian.plugins.authentication.sso.web.DarkFeatureDrivenSessionDataCacheFactory;
import com.atlassian.plugins.authentication.sso.web.NoOpPostAuthenticationProcessor;
import com.atlassian.plugins.authentication.sso.web.PostAuthenticationProcessor;
import com.atlassian.plugins.authentication.sso.web.SessionDataCacheFactory;
import com.atlassian.plugins.authentication.sso.web.filter.authentication.confluence.ConfluenceActionResolver;
import com.atlassian.plugins.authentication.sso.web.filter.authentication.confluence.StaticConfluenceActionResolver;
import com.atlassian.plugins.authentication.sso.web.filter.authentication.confluence.Struts2ActionResolver;
import com.atlassian.plugins.authentication.sso.web.loginpage.ProductLoginPageDataService;
import com.atlassian.plugins.authentication.sso.web.loginpage.ProductLoginPageDataServiceFactory;
import com.atlassian.plugins.authentication.sso.web.loginpage.SingleApplicationProductLoginPageDataServiceFactory;
import com.atlassian.plugins.authentication.sso.web.usercontext.impl.jit.DirectoryQueryJitDirectoriesFinder;
import com.atlassian.plugins.authentication.sso.web.usercontext.impl.jit.JitDirectoriesFinder;
import com.atlassian.plugins.authentication.sso.web.usercontext.rememberme.RememberMeCookieHandler;
import com.atlassian.plugins.authentication.sso.web.usercontext.rememberme.SeraphRememberMeCookieHandler;
import com.atlassian.plugins.authentication.tsv.service.ConfluenceTotpIssuerService;
import com.atlassian.plugins.authentication.tsv.service.TotpIssuerService;
import com.atlassian.plugins.authentication.tsv.service.session.AuthenticatedSessionCreator;
import com.atlassian.plugins.authentication.tsv.service.session.EmbeddedCrowdAuthenticatedSessionCreator;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.ConfluenceOnly;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.spring.container.ContainerManager;
import org.apache.struts2.dispatcher.Dispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@Configuration
@Import(value={ConfluenceImportConfiguration.class, CommonImportsConfiguration.class})
@Conditional(value={ConfluenceOnly.class})
public class ConfluenceSsoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfluenceSsoConfiguration.class);

    @Bean
    public ProductLoginOptionChecker productLoginOptionChecker(LoginOptionsService loginOptionsService) {
        return new DefaultLoginOptionChecker(loginOptionsService);
    }

    @Bean
    public NodeIdProvider nodeIdProvider(ClusterManager clusterManager) {
        return new ConfluenceNodeIdProvider(clusterManager);
    }

    @Bean
    public SessionDataCacheFactory sessionDataCacheFactory(DarkFeatureManager darkFeatureManager, CacheManager cacheManager) {
        return new DarkFeatureDrivenSessionDataCacheFactory(darkFeatureManager, cacheManager);
    }

    @Bean
    public ProductLicenseChecker productLicenseChecker(LicenseService licenseService, UserChecker userChecker) {
        return new ConfluenceLicenseChecker(licenseService, userChecker);
    }

    @Bean
    public JitDirectoriesFinder jitDirectoriesFinder(DirectoryManager directoryManager) {
        return new DirectoryQueryJitDirectoriesFinder(directoryManager);
    }

    @Bean
    public LegacyAuthenticationMethodsDataProvider legacyAuthenticationMethodsDataProvider(SettingsManager settingsManager) {
        return new ConfluenceLegacyAuthenticationMethodsDataProvider(settingsManager);
    }

    @Bean
    public RememberMeCookieHandler rememberMeCookieHandler() {
        return new SeraphRememberMeCookieHandler();
    }

    @Bean
    public RedirectsLoopPreventer redirectsLoopPreventer() {
        return new SeraphRedirectsLoopPreventer();
    }

    @Bean
    public JohnsonChecker johnsonChecker() {
        return new JohnsonSkippedJohnsonChecker();
    }

    @Bean
    public ConfluenceActionResolver staticConfluenceActionResolver() {
        return new StaticConfluenceActionResolver("com.atlassian.confluence.user.actions.LoginAction", "com.atlassian.confluence.user.actions.SignUpAction");
    }

    @Bean
    @Primary
    public ConfluenceActionResolver defaultConfluenceActionResolver() {
        return new Struts2ActionResolver((Dispatcher)ContainerManager.getComponent((String)"strutsDispatcher", Dispatcher.class));
    }

    @Bean
    public ProductLoginPageDataServiceFactory productLoginPageDataServiceFactory(ProductLoginPageDataService productLoginPageDataService) {
        return new SingleApplicationProductLoginPageDataServiceFactory(productLoginPageDataService);
    }

    @Bean
    public TotpIssuerService totpIssuerService(ApplicationProperties salApplicationProperties, SettingsManager settingsManager) {
        return new ConfluenceTotpIssuerService(salApplicationProperties, settingsManager);
    }

    @Bean
    public AlternateLoginPageUriProvider alternateLoginPageUriProvider(LoginUriProvider loginUriProvider, TargetUrlNormalizer targetUrlNormalizer) {
        return new DefaultAlternateLoginPageUriProvider(loginUriProvider, targetUrlNormalizer);
    }

    @Bean
    public PostAuthenticationProcessor postAuthenticationProcessor() {
        return new NoOpPostAuthenticationProcessor();
    }

    @Bean
    public AuthenticatedSessionCreator authenticatedSessionCreator(AuthenticationListener authenticationListener, I18nResolver i18nResolver) {
        return new EmbeddedCrowdAuthenticatedSessionCreator(authenticationListener, i18nResolver);
    }
}

