/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.spring;

import com.atlassian.audit.api.AuditService;
import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.service.CrowdRememberMeService;
import com.atlassian.crowd.service.authentication.CrowdApplicationAuthenticationService;
import com.atlassian.crowd.service.cluster.ClusterService;
import com.atlassian.crowd.service.license.LicenseService;
import com.atlassian.plugins.authentication.api.config.LoginOptionsService;
import com.atlassian.plugins.authentication.captcha.CaptchaService;
import com.atlassian.plugins.authentication.captcha.impl.AlwaysDisabledCaptchaService;
import com.atlassian.plugins.authentication.common.analytics.NodeIdProvider;
import com.atlassian.plugins.authentication.common.analytics.product.CrowdNodeIdProvider;
import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;
import com.atlassian.plugins.authentication.common.properties.SystemPropertyBasedAuthenticationPluginFeatureService;
import com.atlassian.plugins.authentication.common.properties.crowd.CrowdAuthenticationPluginFeatureService;
import com.atlassian.plugins.authentication.common.spring.CommonImportsConfiguration;
import com.atlassian.plugins.authentication.common.web.AlternateLoginPageUriProvider;
import com.atlassian.plugins.authentication.common.web.DefaultAlternateLoginPageUriProvider;
import com.atlassian.plugins.authentication.common.web.loopsprevention.NoopRedirectsLoopPreventer;
import com.atlassian.plugins.authentication.common.web.loopsprevention.RedirectsLoopPreventer;
import com.atlassian.plugins.authentication.sso.johnson.DefaultJohnsonChecker;
import com.atlassian.plugins.authentication.sso.johnson.JohnsonChecker;
import com.atlassian.plugins.authentication.sso.license.CrowdLicenseChecker;
import com.atlassian.plugins.authentication.sso.license.ProductLicenseChecker;
import com.atlassian.plugins.authentication.sso.option.DefaultLoginOptionChecker;
import com.atlassian.plugins.authentication.sso.option.ProductLoginOptionChecker;
import com.atlassian.plugins.authentication.sso.util.DefaultLegacyAuthenticationMethodsDataProvider;
import com.atlassian.plugins.authentication.sso.util.LegacyAuthenticationMethodsDataProvider;
import com.atlassian.plugins.authentication.sso.util.TargetUrlNormalizer;
import com.atlassian.plugins.authentication.sso.web.GuavaSessionDataCacheFactory;
import com.atlassian.plugins.authentication.sso.web.NoOpPostAuthenticationProcessor;
import com.atlassian.plugins.authentication.sso.web.PostAuthenticationProcessor;
import com.atlassian.plugins.authentication.sso.web.SessionDataCacheFactory;
import com.atlassian.plugins.authentication.sso.web.loginpage.CrowdProductLoginPageDataService;
import com.atlassian.plugins.authentication.sso.web.loginpage.ProductLoginPageDataService;
import com.atlassian.plugins.authentication.sso.web.loginpage.ProductLoginPageDataServiceFactory;
import com.atlassian.plugins.authentication.sso.web.loginpage.SingleApplicationProductLoginPageDataServiceFactory;
import com.atlassian.plugins.authentication.sso.web.usercontext.impl.jit.DirectoryQueryJitDirectoriesFinder;
import com.atlassian.plugins.authentication.sso.web.usercontext.impl.jit.JitDirectoriesFinder;
import com.atlassian.plugins.authentication.sso.web.usercontext.rememberme.CrowdRememberMeCookieHandler;
import com.atlassian.plugins.authentication.sso.web.usercontext.rememberme.RememberMeCookieHandler;
import com.atlassian.plugins.authentication.tsv.auth.callback.FailedLoginAttemptCallback;
import com.atlassian.plugins.authentication.tsv.auth.callback.impl.NoOpFailedLoginAttemptCallback;
import com.atlassian.plugins.authentication.tsv.service.audit.CrowdAuditLogMapper;
import com.atlassian.plugins.authentication.tsv.service.audit.CrowdAuditService;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.AuthenticationFailedResponseBuilder;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.CredentialVerificationService;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.CrowdCredentialVerificationService;
import com.atlassian.plugins.authentication.tsv.service.responsebuilder.CrowdAuthenticationFailedResponseBuilder;
import com.atlassian.plugins.authentication.tsv.service.session.AuthenticatedSessionCreator;
import com.atlassian.plugins.authentication.tsv.service.session.CrowdAuthenticatedSessionCreator;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.CrowdOnly;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={CommonImportsConfiguration.class})
@Conditional(value={CrowdOnly.class})
public class CrowdSsoConfiguration {
    @Bean
    public AuditService auditService(com.atlassian.crowd.manager.audit.AuditService crowdAuditService, I18nResolver i18nResolver) {
        return new CrowdAuditService(crowdAuditService, new CrowdAuditLogMapper(i18nResolver));
    }

    @Bean
    public NodeIdProvider nodeIdProvider(ClusterService clusterService) {
        return new CrowdNodeIdProvider(clusterService);
    }

    @Bean
    public SessionDataCacheFactory sessionDataCacheFactory() {
        return new GuavaSessionDataCacheFactory();
    }

    @Bean
    public ProductLoginOptionChecker productLoginOptionChecker(LoginOptionsService loginOptionsService) {
        return new DefaultLoginOptionChecker(loginOptionsService);
    }

    @Bean
    public LegacyAuthenticationMethodsDataProvider legacyAuthenticationMethodsDataProvider() {
        return new DefaultLegacyAuthenticationMethodsDataProvider();
    }

    @Bean
    public RememberMeCookieHandler rememberMeCookieHandler(CrowdRememberMeService crowdRememberMeService) {
        return new CrowdRememberMeCookieHandler(crowdRememberMeService);
    }

    @Bean
    public RedirectsLoopPreventer redirectsLoopPreventer() {
        return new NoopRedirectsLoopPreventer();
    }

    @Bean
    public JitDirectoriesFinder jitDirectoriesFinder(DirectoryManager directoryManager) {
        return new DirectoryQueryJitDirectoriesFinder(directoryManager);
    }

    @Bean
    public ProductLicenseChecker productLicenseChecker(LicenseService licenseService, PropertyManager propertyManager) {
        return new CrowdLicenseChecker(licenseService, propertyManager);
    }

    @Bean
    public JohnsonChecker johnsonChecker() {
        return new DefaultJohnsonChecker();
    }

    @Bean
    public ProductLoginPageDataService crowdProductLoginPageDataService(ApplicationProperties applicationProperties, ApplicationFactory applicationFactory, CrowdRememberMeService crowdRememberMeService, PropertyManager propertyManager) {
        return new CrowdProductLoginPageDataService(applicationProperties, applicationFactory, crowdRememberMeService, propertyManager);
    }

    @Bean
    public ProductLoginPageDataServiceFactory productLoginPageDataServiceFactory(ProductLoginPageDataService productLoginPageDataService) {
        return new SingleApplicationProductLoginPageDataServiceFactory(productLoginPageDataService);
    }

    @Bean
    public AlternateLoginPageUriProvider alternateLoginPageUriProvider(LoginUriProvider loginUriProvider, TargetUrlNormalizer targetUrlNormalizer) {
        return new DefaultAlternateLoginPageUriProvider(loginUriProvider, targetUrlNormalizer);
    }

    @Bean
    public AuthenticationPluginFeatureInternalService authenticationPluginFeatureService() {
        return new CrowdAuthenticationPluginFeatureService(new SystemPropertyBasedAuthenticationPluginFeatureService());
    }

    @Bean
    public CredentialVerificationService credentialVerificationService(CrowdService crowdService, UserManager userManager) {
        return new CrowdCredentialVerificationService(crowdService, userManager);
    }

    @Bean
    public CaptchaService captchaService() {
        return new AlwaysDisabledCaptchaService();
    }

    @Bean
    public PropertyManager getPropertyManager() {
        return (PropertyManager)OsgiServices.importOsgiService(PropertyManager.class);
    }

    @Bean
    public CrowdRememberMeService crowdRememberMeService() {
        return (CrowdRememberMeService)OsgiServices.importOsgiService(CrowdRememberMeService.class);
    }

    @Bean
    public PostAuthenticationProcessor postAuthenticationProcessor() {
        return new NoOpPostAuthenticationProcessor();
    }

    @Bean
    public FailedLoginAttemptCallback failedLoginAuthenticationCallback() {
        return new NoOpFailedLoginAttemptCallback();
    }

    @Bean
    public AuthenticationFailedResponseBuilder authenticationFailedResponseBuilder(I18nResolver i18nResolver) {
        return new CrowdAuthenticationFailedResponseBuilder(i18nResolver);
    }

    @Bean
    public AuthenticatedSessionCreator authenticatedSessionCreator(CrowdApplicationAuthenticationService crowdApplicationAuthenticationService) {
        return new CrowdAuthenticatedSessionCreator(crowdApplicationAuthenticationService);
    }

    @Bean
    public CrowdApplicationAuthenticationService crowdApplicationAuthenticationService() {
        return (CrowdApplicationAuthenticationService)OsgiServices.importOsgiService(CrowdApplicationAuthenticationService.class);
    }
}

