/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.spring;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.plugins.authentication.api.config.LoginOptionsService;
import com.atlassian.plugins.authentication.common.analytics.NodeIdProvider;
import com.atlassian.plugins.authentication.common.analytics.product.RefAppNodeIdProvider;
import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;
import com.atlassian.plugins.authentication.common.properties.SystemPropertyBasedAuthenticationPluginFeatureService;
import com.atlassian.plugins.authentication.common.spring.CommonImportsConfiguration;
import com.atlassian.plugins.authentication.common.web.AlternateLoginPageUriProvider;
import com.atlassian.plugins.authentication.common.web.DefaultAlternateLoginPageUriProvider;
import com.atlassian.plugins.authentication.sso.license.ProductLicenseChecker;
import com.atlassian.plugins.authentication.sso.license.RefAppLicenseChecker;
import com.atlassian.plugins.authentication.sso.option.DefaultLoginOptionChecker;
import com.atlassian.plugins.authentication.sso.option.ProductLoginOptionChecker;
import com.atlassian.plugins.authentication.sso.util.DefaultLegacyAuthenticationMethodsDataProvider;
import com.atlassian.plugins.authentication.sso.util.LegacyAuthenticationMethodsDataProvider;
import com.atlassian.plugins.authentication.sso.util.TargetUrlNormalizer;
import com.atlassian.plugins.authentication.sso.web.GuavaSessionDataCacheFactory;
import com.atlassian.plugins.authentication.sso.web.NoOpPostAuthenticationProcessor;
import com.atlassian.plugins.authentication.sso.web.PostAuthenticationProcessor;
import com.atlassian.plugins.authentication.sso.web.SessionDataCacheFactory;
import com.atlassian.plugins.authentication.sso.web.loginpage.NoOpProductLoginPageDataService;
import com.atlassian.plugins.authentication.sso.web.loginpage.ProductLoginPageDataService;
import com.atlassian.plugins.authentication.sso.web.usercontext.impl.jit.DirectoryQueryJitDirectoriesFinder;
import com.atlassian.plugins.authentication.sso.web.usercontext.impl.jit.JitDirectoriesFinder;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.AuthenticationFailedResponseBuilder;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.CredentialVerificationService;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.EmbeddedCrowdCredentialVerificationService;
import com.atlassian.plugins.authentication.tsv.service.responsebuilder.DefaultAuthenticationFailedResponseBuilder;
import com.atlassian.plugins.authentication.tsv.service.session.AuthenticatedSessionCreator;
import com.atlassian.plugins.authentication.tsv.service.session.EmbeddedCrowdAuthenticatedSessionCreator;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.RefappOnly;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={CommonImportsConfiguration.class})
@Conditional(value={RefappOnly.class})
public class RefAppSsoConfiguration {
    @Bean
    public ProductLoginOptionChecker productLoginOptionChecker(LoginOptionsService loginOptionsService) {
        return new DefaultLoginOptionChecker(loginOptionsService);
    }

    @Bean
    public ProductLicenseChecker productLicenseChecker() {
        return new RefAppLicenseChecker();
    }

    @Bean
    public NodeIdProvider nodeIdProvider() {
        return new RefAppNodeIdProvider();
    }

    @Bean
    public JitDirectoriesFinder jitDirectoriesFinder(DirectoryManager directoryManager) {
        return new DirectoryQueryJitDirectoriesFinder(directoryManager);
    }

    @Bean
    public SessionDataCacheFactory sessionDataCacheFactory() {
        return new GuavaSessionDataCacheFactory();
    }

    @Bean
    public LegacyAuthenticationMethodsDataProvider legacyAuthenticationMethodsDataProvider() {
        return new DefaultLegacyAuthenticationMethodsDataProvider();
    }

    @Bean
    public ProductLoginPageDataService loginPageDataService() {
        return new NoOpProductLoginPageDataService();
    }

    @Bean
    public CredentialVerificationService credentialVerificationService(CrowdService crowdService, UserManager userManager) {
        return new EmbeddedCrowdCredentialVerificationService(crowdService, userManager);
    }

    @Bean
    public AlternateLoginPageUriProvider alternateLoginPageUriProvider(LoginUriProvider loginUriProvider, TargetUrlNormalizer targetUrlNormalizer) {
        return new DefaultAlternateLoginPageUriProvider(loginUriProvider, targetUrlNormalizer);
    }

    @Bean
    public AuthenticationPluginFeatureInternalService authenticationPluginFeatureService() {
        return new SystemPropertyBasedAuthenticationPluginFeatureService();
    }

    @Bean
    public PostAuthenticationProcessor postAuthenticationProcessor() {
        return new NoOpPostAuthenticationProcessor();
    }

    @Bean
    public AuthenticationFailedResponseBuilder authenticationFailedResponseBuilder(I18nResolver i18nResolver) {
        return new DefaultAuthenticationFailedResponseBuilder(i18nResolver);
    }

    @Bean
    public AuthenticatedSessionCreator authenticatedSessionCreator(AuthenticationListener authenticationListener, I18nResolver i18nResolver) {
        return new EmbeddedCrowdAuthenticatedSessionCreator(authenticationListener, i18nResolver);
    }
}

