/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.spring;

import com.atlassian.plugins.authentication.common.spring.CommonImportsConfiguration;
import com.atlassian.plugins.authentication.sso.config.IdpConfigValidatorProvider;
import com.atlassian.plugins.authentication.sso.config.SsoConfigValidator;
import com.atlassian.plugins.authentication.sso.config.SsoConfigValidatorImpl;
import com.atlassian.plugins.authentication.sso.config.oidc.OidcConfigValidator;
import com.atlassian.plugins.authentication.sso.config.saml.SamlConfigValidator;
import com.atlassian.plugins.authentication.sso.util.CronExpressionValidatorImpl;
import com.atlassian.plugins.authentication.sso.util.HttpsValidator;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.cron.CronExpressionValidator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={CommonImportsConfiguration.class})
public class ValidatorConfiguration {
    @Bean
    public CronExpressionValidator cronExpressionValidator(SchedulerService schedulerService) {
        return new CronExpressionValidatorImpl(schedulerService);
    }

    @Bean
    public SsoConfigValidator ssoConfigValidator(CronExpressionValidator cronExpressionValidator) {
        return new SsoConfigValidatorImpl(cronExpressionValidator);
    }

    @Bean
    public HttpsValidator httpsValidator(ApplicationProperties applicationProperties, DarkFeatureManager darkFeatureManager) {
        return new HttpsValidator(applicationProperties, darkFeatureManager);
    }

    @Bean
    public SamlConfigValidator samlConfigValidator(HttpsValidator httpsValidator) {
        return new SamlConfigValidator(httpsValidator);
    }

    @Bean
    public OidcConfigValidator oidcConfigValidator(HttpsValidator httpsValidator) {
        return new OidcConfigValidator(httpsValidator);
    }

    @Bean
    public IdpConfigValidatorProvider idpConfigValidatorProvider(SamlConfigValidator samlConfigValidator, OidcConfigValidator oidcConfigValidator) {
        return new IdpConfigValidatorProvider(samlConfigValidator, oidcConfigValidator);
    }
}

