/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.google.common.base.Strings;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.Optional;

public class CookieService {
    private static final String COOKIE_WITHOUT_SAMESITE_RESTRICTIONS_PATTERN = "%s=%s; Path=%s; Max-Age=%s; Secure; HttpOnly; SameSite=None";
    private final ApplicationProperties applicationProperties;

    public CookieService(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public Optional<Cookie> getCookieFromRequest(String cookieName, HttpServletRequest request) {
        Cookie[] cookies = Optional.ofNullable(request.getCookies()).orElse(new Cookie[0]);
        return Arrays.stream(cookies).filter(cookie -> cookie.getName().equals(cookieName)).findAny();
    }

    public void removeCookie(String cookieName, HttpServletResponse response) {
        Cookie cookieToRemove = new Cookie(cookieName, null);
        cookieToRemove.setMaxAge(0);
        cookieToRemove.setPath(this.buildCookiePath());
        response.addCookie(cookieToRemove);
    }

    public String buildCookiePath() {
        String relativeBaseUrl = this.applicationProperties.getBaseUrl(UrlMode.RELATIVE);
        return Strings.isNullOrEmpty((String)relativeBaseUrl) ? "/" : relativeBaseUrl;
    }

    public void storeCookieWithoutSameSiteRestrictions(String cookieName, String cookieValue, int maxAgeInSeconds, HttpServletResponse response) {
        response.addHeader("Set-Cookie", String.format(COOKIE_WITHOUT_SAMESITE_RESTRICTIONS_PATTERN, cookieName, cookieValue, this.buildCookiePath(), maxAgeInSeconds));
    }
}

