/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web;

import com.atlassian.plugins.authentication.sso.web.CookieService;
import com.atlassian.plugins.authentication.sso.web.SessionData;
import com.atlassian.plugins.authentication.sso.web.SessionDataCache;
import com.atlassian.plugins.authentication.sso.web.SessionDataCacheConfiguration;
import com.atlassian.plugins.authentication.sso.web.SessionDataCacheFactory;
import com.atlassian.plugins.authentication.util.SafeBasePathUtil;
import com.atlassian.sal.api.ApplicationProperties;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionDataService {
    private static final Logger log = LoggerFactory.getLogger(SessionDataService.class);
    public static final String COOKIE_NAME_PREFIX = "session-data-";
    public static final String USER_LOGGED_IN_WITH_SSO = "com.atlassian.plugins.authentication.userLoggedInWithSso";
    static final String AUTH_SESSION_DATA = "com.atlassian.plugins.authentication.sessiondata";
    static final String SESSION_DATA_LIFETIME_IN_SECONDS_PROPERTY_NAME = "com.atlassian.plugins.authentication.impl.web.SessionDataService.requestIdGracePeriodSeconds";
    static final int DEFAULT_SESSION_DATA_LIFETIME_IN_SECONDS = 300;
    private static final String LOGGED_OUT_FROM_SERVICE_DESK = "was-logged-out";
    private static final String CROWD_RENDERED_LOGIN_PAGE_ATTRIBUTE = "SPRING_SECURITY_CROWD_RENDERED_LOGIN_PAGE";
    private final CookieService cookieService;
    private final SessionDataCache globalSessionDataCache;
    private final int requestIdGracePeriod;
    private final ApplicationProperties applicationProperties;

    public SessionDataService(CookieService cookieService, ApplicationProperties applicationProperties, SessionDataCacheFactory sessionDataCacheFactory) {
        this(cookieService, applicationProperties, Integer.getInteger(SESSION_DATA_LIFETIME_IN_SECONDS_PROPERTY_NAME, 300), sessionDataCacheFactory);
    }

    @VisibleForTesting
    SessionDataService(CookieService cookieService, ApplicationProperties applicationProperties, int requestIdGracePeriod, SessionDataCacheFactory sessionDataCacheFactory) {
        this.cookieService = cookieService;
        this.applicationProperties = applicationProperties;
        this.requestIdGracePeriod = requestIdGracePeriod;
        this.globalSessionDataCache = sessionDataCacheFactory.createSessionDataCache(new SessionDataCacheConfiguration(requestIdGracePeriod));
    }

    public void setSessionData(HttpServletRequest request, HttpServletResponse response, String key, SessionData sessionData) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)sessionData);
        request.getSession(true);
        this.cookieService.storeCookieWithoutSameSiteRestrictions(COOKIE_NAME_PREFIX + key, "", this.requestIdGracePeriod, response);
        this.globalSessionDataCache.put(key, sessionData);
        log.debug("Saved login session data {} in user session: {} using key {}", new Object[]{sessionData, request.getSession().getId(), key});
    }

    public Optional<SessionData> getSessionData(HttpServletRequest request, HttpServletResponse response, String key) {
        if (key == null) {
            return Optional.empty();
        }
        String cookieName = COOKIE_NAME_PREFIX + key;
        return this.cookieService.getCookieFromRequest(cookieName, request).flatMap(cookie -> {
            this.cookieService.removeCookie(cookieName, response);
            SessionData sessionData = this.globalSessionDataCache.get(key);
            this.globalSessionDataCache.remove(key);
            if (sessionData != null) {
                Optional<String> urlFragment = this.extractAndInvalidateFragmentCookieValue(request, response, sessionData.getAuthenticationRequest().getPublicId());
                return Optional.of(new SessionData(sessionData.getAuthenticationRequest(), this.prepareTargetUrlWithFragment(sessionData.getTargetUrl(), urlFragment), sessionData.getIdpConfigId()));
            }
            return Optional.empty();
        });
    }

    private Optional<String> extractAndInvalidateFragmentCookieValue(HttpServletRequest request, HttpServletResponse response, String key) {
        String cookieName = "atlassian-authentication-plugin-url-fragment_" + key;
        Optional<Cookie> fragmentCookie = this.cookieService.getCookieFromRequest(cookieName, request);
        fragmentCookie.ifPresent(cookie -> this.cookieService.removeCookie(cookieName, response));
        return fragmentCookie.map(Cookie::getValue);
    }

    private URI prepareTargetUrlWithFragment(Optional<URI> targetUri, Optional<String> fragment) {
        if (fragment.isPresent()) {
            return targetUri.map(UriBuilder::fromUri).orElse(UriBuilder.fromPath((String)SafeBasePathUtil.getBaseRedirectPath(this.applicationProperties))).fragment(fragment.get()).build(new Object[0]);
        }
        return targetUri.orElse(null);
    }

    public HttpSession ensureSessionExists(HttpServletRequest request) {
        return request.getSession(true);
    }

    public void requireNewSession(HttpServletRequest request) {
        Map<String, Object> attributes;
        HttpSession oldSession = request.getSession(false);
        if (oldSession != null) {
            attributes = this.extractAttributes(oldSession);
            try {
                oldSession.invalidate();
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            attributes = Collections.emptyMap();
        }
        HttpSession session = this.ensureSessionExists(request);
        this.transferAttributes(session, attributes);
    }

    private void transferAttributes(HttpSession session, Map<String, Object> attributes) {
        attributes.forEach((arg_0, arg_1) -> ((HttpSession)session).setAttribute(arg_0, arg_1));
    }

    private Map<String, Object> extractAttributes(@Nonnull HttpSession session) {
        if (!Objects.equals(this.applicationProperties.getPlatformId(), "crowd")) {
            return Collections.emptyMap();
        }
        Object renderedLoginPageAttribute = session.getAttribute(CROWD_RENDERED_LOGIN_PAGE_ATTRIBUTE);
        return renderedLoginPageAttribute == null ? Collections.emptyMap() : Map.of(CROWD_RENDERED_LOGIN_PAGE_ATTRIBUTE, renderedLoginPageAttribute);
    }

    public void setUserLoggedInWithSso(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        session.setAttribute(USER_LOGGED_IN_WITH_SSO, (Object)Boolean.TRUE);
    }

    public void setUserLoggedInWith2sv(HttpServletRequest request) {
        request.setAttribute("com.atlassian.plugins.authentication.2sv.login", (Object)Boolean.TRUE);
    }

    public boolean isUserLoggedInWithSso(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return false;
        }
        Object sessionAttribute = session.getAttribute(USER_LOGGED_IN_WITH_SSO);
        return sessionAttribute != null && (Boolean)sessionAttribute != false;
    }

    public boolean wasLoggedOutFromJsmCustomerPortal(HttpServletRequest request) {
        return Boolean.TRUE.equals(request.getSession(true).getAttribute(LOGGED_OUT_FROM_SERVICE_DESK));
    }

    public void setLoggedOutFromJsmCustomerPortal(HttpServletRequest request, boolean value) {
        HttpSession session = request.getSession(true);
        if (value) {
            session.setAttribute(LOGGED_OUT_FROM_SERVICE_DESK, (Object)value);
        } else {
            session.removeAttribute(LOGGED_OUT_FROM_SERVICE_DESK);
        }
    }

    public String extractTargetUrlOrReturnBaseUrl(Optional<SessionData> sessionData) {
        String relativeBaseUrl = SafeBasePathUtil.getRelativeBaseUrl(this.applicationProperties);
        return sessionData.flatMap(SessionData::getTargetUrl).flatMap(uri -> uri.toString().isEmpty() ? Optional.empty() : Optional.of(uri)).map(uri -> UriBuilder.fromUri((URI)uri).replacePath("").path(relativeBaseUrl).path(uri.getPath()).build(new Object[0]).toString()).orElse(SafeBasePathUtil.getBaseRedirectPath(this.applicationProperties, relativeBaseUrl));
    }
}

