/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugins.authentication.sso.config.IdpNotFoundException;
import com.atlassian.plugins.authentication.sso.johnson.JohnsonChecker;
import com.atlassian.plugins.authentication.sso.rest.exception.KeyCertificatePairConfigurationException;
import com.atlassian.plugins.authentication.sso.web.AuthenticationHandlerNotConfiguredException;
import com.atlassian.plugins.authentication.sso.web.InvalidLicenseException;
import com.atlassian.plugins.authentication.sso.web.filter.AbstractJohnsonAwareFilter;
import com.atlassian.plugins.authentication.sso.web.saml.provider.InvalidSamlResponse;
import com.atlassian.plugins.authentication.sso.web.usercontext.AuthenticationFailedException;
import com.atlassian.plugins.authentication.sso.web.usercontext.IdentifiableRuntimeException;
import com.atlassian.plugins.authentication.sso.web.usercontext.IdpNotApplicableException;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class ErrorHandlingFilter
extends AbstractJohnsonAwareFilter {
    private static final Logger log = LoggerFactory.getLogger(ErrorHandlingFilter.class);
    private static final String INCLUDE_STACKTRACE_DARKFEATURE = "atlassian.authentication.include.stacktrace.in.error.messages";
    public static final String TEMPLATE_COMPLETE_KEY = "com.atlassian.plugins.authentication.atlassian-authentication-plugin:templates";
    public static final String INVALID_SAML_RESPONSE_TEMPLATE_NAME_WITH_NAMESPACE = "AuthenticationPlugin.InvalidSamlResponse.display";
    public static final String AUTHENTICATION_FAILED_TEMPLATE_NAME_WITH_NAMESPACE = "AuthenticationPlugin.AuthenticationFailed.display";
    public static final String IDP_NOT_APPLICABLE_TEMPLATE_NAME_WITH_NAMESPACE = "AuthenticationPlugin.IdpNotApplicable.display";
    public static final String KEYPAIR_ERROR_TEMPLATE_NAME_WITH_NAMESPACE = "AuthenticationPlugin.KeyCertificatePairConfigurationError.display";
    public static final String AUTHENTICATION_NOT_CONFIGURED_TEMPLATE_NAME_WITH_NAMESPACE = "AuthenticationPlugin.AuthenticationNotConfigured.display";
    public static final String IDP_NOT_FOUND_TEMPLATE_NAME_WITH_NAMESPACE = "AuthenticationPlugin.IdpNotFound.display";
    public static final String REFERRER_POLICY_HEADER = "Referrer-Policy";
    public static final String ORIGIN_WHEN_CROSS_ORIGIN = "origin-when-cross-origin";
    private static final String RESPONSE_CONTENT_TYPE = "text/html";
    private final SoyTemplateRenderer templateRenderer;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final LoginUriProvider loginUriProvider;
    private final ApplicationProperties applicationProperties;
    private final DarkFeatureManager darkFeatureManager;

    public ErrorHandlingFilter(SoyTemplateRenderer templateRenderer, WebResourceUrlProvider webResourceUrlProvider, LoginUriProvider loginUriProvider, ApplicationProperties applicationProperties, DarkFeatureManager darkFeatureManager, JohnsonChecker johnsonChecker) {
        super(johnsonChecker);
        this.templateRenderer = templateRenderer;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.loginUriProvider = loginUriProvider;
        this.applicationProperties = applicationProperties;
        this.darkFeatureManager = darkFeatureManager;
    }

    @Override
    protected void doFilterInternal(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        catch (IdpNotFoundException e) {
            this.logException(e);
            this.renderResponse(response, IDP_NOT_FOUND_TEMPLATE_NAME_WITH_NAMESPACE, 404, (Map<String, Object>)ImmutableMap.of((Object)"idpId", (Object)e.getId()), e);
        }
        catch (AuthenticationHandlerNotConfiguredException | InvalidLicenseException e) {
            this.logException(e);
            this.renderResponse(response, AUTHENTICATION_NOT_CONFIGURED_TEMPLATE_NAME_WITH_NAMESPACE, 400, (Map<String, Object>)ImmutableMap.of(), e);
        }
        catch (InvalidSamlResponse e) {
            this.logException(e);
            ImmutableMap.Builder templateParametersBuilder = ImmutableMap.builder().put((Object)"productName", (Object)this.applicationProperties.getDisplayName());
            String targetUrl = this.prepareTargetUrl(e);
            if (targetUrl != null) {
                templateParametersBuilder.put((Object)"url", (Object)this.prepareTargetUrl(e));
            }
            this.renderResponse(response, INVALID_SAML_RESPONSE_TEMPLATE_NAME_WITH_NAMESPACE, 400, (Map<String, Object>)templateParametersBuilder.build(), e);
        }
        catch (AuthenticationFailedException e) {
            this.logException(e);
            this.renderResponse(response, AUTHENTICATION_FAILED_TEMPLATE_NAME_WITH_NAMESPACE, 400, (Map<String, Object>)ImmutableMap.of(), e);
        }
        catch (IdpNotApplicableException e) {
            this.logException(e);
            this.renderResponse(response, IDP_NOT_APPLICABLE_TEMPLATE_NAME_WITH_NAMESPACE, 400, (Map<String, Object>)ImmutableMap.of((Object)"loginPageUrl", (Object)e.getLoginPageUrl()), e);
        }
        catch (KeyCertificatePairConfigurationException e) {
            this.logException(e);
            this.renderResponse(response, KEYPAIR_ERROR_TEMPLATE_NAME_WITH_NAMESPACE, 400, (Map<String, Object>)ImmutableMap.of(), e);
        }
    }

    private void logException(Exception e) {
        if (e instanceof IdentifiableRuntimeException) {
            log.error(String.format("[UUID: %s] %s", ((IdentifiableRuntimeException)e).getUuid(), e.getMessage()), (Throwable)e);
        } else {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void renderResponse(HttpServletResponse responseToFill, String templateNameWithNamespace, int statusCode, Map<String, Object> customMappings, Throwable error) throws IOException {
        responseToFill.setContentType(RESPONSE_CONTENT_TYPE);
        responseToFill.setStatus(statusCode);
        responseToFill.setHeader(REFERRER_POLICY_HEADER, ORIGIN_WHEN_CROSS_ORIGIN);
        this.templateRenderer.render((Appendable)responseToFill.getWriter(), TEMPLATE_COMPLETE_KEY, templateNameWithNamespace, this.prepareMappings(customMappings, error));
    }

    private Map<String, Object> prepareMappings(Map<String, Object> customMappings, Throwable error) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        if (error instanceof IdentifiableRuntimeException) {
            mapBuilder.put((Object)"errorUuid", (Object)((IdentifiableRuntimeException)error).getUuid().toString());
        }
        if (this.shouldIncludeStackTrace()) {
            mapBuilder.put((Object)"stackTrace", (Object)Throwables.getStackTraceAsString((Throwable)error));
        }
        mapBuilder.put((Object)"errorImgUrl", (Object)this.webResourceUrlProvider.getStaticPluginResourceUrl(TEMPLATE_COMPLETE_KEY, "error", com.atlassian.webresource.api.UrlMode.RELATIVE)).putAll(customMappings);
        return mapBuilder.build();
    }

    public String prepareTargetUrl(InvalidSamlResponse invalidSamlResponse) {
        try {
            if (invalidSamlResponse.getTargetUrl() != null) {
                return this.loginUriProvider.getLoginUri(new URI(invalidSamlResponse.getTargetUrl())).toString();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (invalidSamlResponse.getIdpConfigId() != null) {
            return this.applicationProperties.getBaseUrl(UrlMode.RELATIVE) + "/plugins/servlet/external-login/" + invalidSamlResponse.getIdpConfigId();
        }
        return null;
    }

    private boolean shouldIncludeStackTrace() {
        return this.darkFeatureManager.isEnabledForAllUsers(INCLUDE_STACKTRACE_DARKFEATURE).orElse(false);
    }
}

