/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.filter.authentication;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.plugins.authentication.api.config.IdpConfigService;
import com.atlassian.plugins.authentication.api.config.LoginOption;
import com.atlassian.plugins.authentication.api.config.LoginOptionsService;
import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;
import com.atlassian.plugins.authentication.sso.johnson.JohnsonChecker;
import com.atlassian.plugins.authentication.sso.web.AuthenticationHandlerProvider;
import com.atlassian.plugins.authentication.sso.web.filter.authentication.AuthenticationFilter;
import com.google.common.base.Strings;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;

@UnrestrictedAccess
public class BitbucketAuthenticationFilter
extends AuthenticationFilter {
    public static final String BITBUCKET_DESTINATION_URI_QUERY_PARAM = "next";
    private final ApplicationPropertiesService applicationPropertiesService;

    public BitbucketAuthenticationFilter(AuthenticationHandlerProvider authenticationHandlerProvider, IdpConfigService idpConfigService, LoginOptionsService loginOptionsService, JohnsonChecker johnsonChecker, AuthenticationPluginFeatureInternalService authenticationPluginFeatureService, ApplicationPropertiesService applicationPropertiesService) {
        super(authenticationHandlerProvider, idpConfigService, loginOptionsService, johnsonChecker, authenticationPluginFeatureService);
        this.applicationPropertiesService = applicationPropertiesService;
    }

    @Override
    protected boolean isProductSpecificSkip(List<LoginOption> loginOptions, HttpServletRequest httpRequest) {
        return !this.applicationPropertiesService.isSetup();
    }

    @Override
    @Nullable
    protected String extractRequestedUrl(HttpServletRequest req) {
        return Strings.emptyToNull((String)req.getParameter(BITBUCKET_DESTINATION_URI_QUERY_PARAM));
    }
}

