/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.filter.loginform;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugins.authentication.api.config.SsoConfig;
import com.atlassian.plugins.authentication.api.config.SsoConfigCachingService;
import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;
import com.atlassian.plugins.authentication.sso.johnson.JohnsonChecker;
import com.atlassian.plugins.authentication.sso.web.filter.loginform.DisableNativeLoginAuthFilter;
import com.atlassian.plugins.authentication.sso.web.filter.loginform.checker.DisabledNativeLoginRequestBlockingChecker;
import com.atlassian.plugins.authentication.sso.web.filter.loginform.writer.DisableNativeLoginLegacyModeAuthResponseWriter;
import com.atlassian.plugins.authentication.sso.web.filter.loginform.writer.DisableNativeLoginTwoStepVerificationAuthResponseWriter;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Response;
import java.util.List;

@UnrestrictedAccess
public class JsmAwareDisableNativeLoginAuthFilter
extends DisableNativeLoginAuthFilter {
    @Inject
    public JsmAwareDisableNativeLoginAuthFilter(JohnsonChecker johnsonChecker, DisableNativeLoginLegacyModeAuthResponseWriter legacyModeAuthResponseWriter, DisableNativeLoginTwoStepVerificationAuthResponseWriter twoStepVerificationAuthResponseWriter, List<DisabledNativeLoginRequestBlockingChecker> blockRequestChecks, SsoConfigCachingService ssoConfigCachingService, AuthenticationPluginFeatureInternalService authenticationPluginFeatureService) {
        super(johnsonChecker, legacyModeAuthResponseWriter, twoStepVerificationAuthResponseWriter, blockRequestChecks, ssoConfigCachingService, authenticationPluginFeatureService);
    }

    @Override
    protected DisableNativeLoginAuthFilter.NativeLoginContext isNativeLoginEnabled(HttpServletRequest request) {
        if (this.isLoginToJsm(request)) {
            return new DisableNativeLoginAuthFilter.NativeLoginContext(this.isNativeLoginEnabled(SsoConfig::getShowLoginFormForJsm), Response.Status.OK);
        }
        return super.isNativeLoginEnabled(request);
    }

    private boolean isLoginToJsm(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        return (servletPath.startsWith("/servicedesk/customer") || servletPath.startsWith("/rest/servicedesk")) && servletPath.endsWith("/user/login");
    }
}

