/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.filter.loginform.checker;

import com.atlassian.plugins.authentication.sso.web.filter.loginform.checker.DisabledNativeLoginRequestBlockingChecker;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class JAuthForcedNativeLoginCredentialsBlockRequestChecker
implements DisabledNativeLoginRequestBlockingChecker {
    private static final Set<String> WEB_SUDO_LOGIN_URIS = Set.of("/websudo", "/mvc/websudo");

    @Override
    public boolean test(HttpServletRequest request) {
        if (DisabledNativeLoginRequestBlockingChecker.isInsecureUrlParamLoginAllowed()) {
            return false;
        }
        return !JAuthForcedNativeLoginCredentialsBlockRequestChecker.isBitbucketWebSudoLoginRequest(request) && StringUtils.isNotBlank((CharSequence)request.getParameter("j_username")) && StringUtils.isNotBlank((CharSequence)request.getParameter("j_password"));
    }

    private static boolean isBitbucketWebSudoLoginRequest(HttpServletRequest request) {
        return request.getSession(false) != null && "POST".equals(request.getMethod()) && request.getRequestURI() != null && WEB_SUDO_LOGIN_URIS.contains(request.getRequestURI().substring(request.getContextPath().length()));
    }
}

