/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.filter.loginform.checker;

import com.atlassian.plugins.authentication.sso.web.filter.loginform.checker.DisabledNativeLoginRequestBlockingChecker;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JiraDisableSessionRequestChecker
implements DisabledNativeLoginRequestBlockingChecker {
    private static final Set<String> ALLOWED_HTTP_METHODS = Set.of("DELETE", "GET", "HEAD");
    private static final String REGEX = "^.*/rest/auth/.+/session";
    private static final Pattern ENDPOINT_PATTERN = Pattern.compile("^.*/rest/auth/.+/session");

    @Override
    public boolean test(HttpServletRequest httpServletRequest) {
        Matcher matcher = ENDPOINT_PATTERN.matcher(httpServletRequest.getRequestURL());
        return matcher.find() && !ALLOWED_HTTP_METHODS.contains(httpServletRequest.getMethod());
    }
}

