/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.loginpage;

import com.atlassian.bitbucket.auth.RememberMeMode;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.plugins.authentication.sso.web.loginpage.ProductLoginPageData;
import com.atlassian.plugins.authentication.sso.web.loginpage.ProductLoginPageDataService;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;

public class BitbucketProductLoginPageDataService
implements ProductLoginPageDataService {
    private static final String FORGOT_PASSWORD = "/passwordreset";
    private static final String SIGNUP = "/signup";
    private final ApplicationPropertiesService propertiesService;
    private final ApplicationProperties salApplicationProperties;

    public BitbucketProductLoginPageDataService(ApplicationPropertiesService propertiesService, ApplicationProperties salApplicationProperties) {
        this.propertiesService = propertiesService;
        this.salApplicationProperties = salApplicationProperties;
    }

    private Object getAttribute(HttpServletRequest request, String attributeName) {
        Object value;
        HttpSession session = request.getSession(false);
        Object object = value = session == null ? null : session.getAttribute(attributeName);
        if (value == null) {
            value = request.getAttribute(attributeName);
        }
        return value;
    }

    @Override
    public ProductLoginPageData getLoginPageData(HttpServletRequest httpServletRequest) {
        String cachedUsername = (String)this.getAttribute(httpServletRequest, "bitbucket.cached-username");
        String successMessage = (String)this.getAttribute(httpServletRequest, "bitbucket.signedup-user-success-message");
        return ProductLoginPageData.builder().setSignupUrl(this.propertiesService.isAllowPublicSignUp() ? this.getSignUpUrl() : null).setForgotPasswordUrl(this.getForgotPasswordUrl()).setRememberMeType(BitbucketProductLoginPageDataService.toRememberMeType(this.propertiesService.getRememberMeMode())).setPrefilledUsername(cachedUsername).setAdditionalSuccessMessage(successMessage).setShowLogo(false).setAuthenticationByEmail(false).build();
    }

    private static ProductLoginPageData.RememberMeType toRememberMeType(RememberMeMode rememberMeMode) {
        return switch (rememberMeMode) {
            case RememberMeMode.ALWAYS -> ProductLoginPageData.RememberMeType.HIDE_CHECKED;
            case RememberMeMode.NEVER -> ProductLoginPageData.RememberMeType.HIDE_UNCHECKED;
            default -> ProductLoginPageData.RememberMeType.SHOW_CHECKED;
        };
    }

    @Nonnull
    private String getForgotPasswordUrl() {
        return this.salApplicationProperties.getBaseUrl(UrlMode.RELATIVE) + FORGOT_PASSWORD;
    }

    @Nonnull
    private String getSignUpUrl() {
        return this.salApplicationProperties.getBaseUrl(UrlMode.RELATIVE) + SIGNUP;
    }
}

