/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.loginpage;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.languages.Language;
import com.atlassian.confluence.languages.LanguageManager;
import com.atlassian.confluence.security.login.LoginPageFunctionalityService;
import com.atlassian.confluence.user.SignupManager;
import com.atlassian.confluence.util.SeraphUtils;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.plugins.authentication.sso.web.loginpage.ProductLoginPageData;
import com.atlassian.plugins.authentication.sso.web.loginpage.ProductLoginPageDataService;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.message.I18nResolver;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.UrlValidator;

public class ConfluenceProductLoginPageDataService
implements ProductLoginPageDataService {
    private static final String FORGOT_PASSWORD_PATH = "/forgotuserpassword.action";
    @VisibleForTesting
    protected static final String[] ATTRIBUTES_WHEN_FORWARDED_TO_SERVLET = new String[]{"jakarta.servlet.forward.request_uri"};
    private final UrlValidator urlValidator = new UrlValidator(new String[]{"http", "https"}, 8L);
    private final LoginPageFunctionalityService loginPageFunctionalityService;
    private final ApplicationProperties applicationProperties;
    private final I18nResolver i18nResolver;
    private final LanguageManager languageManager;
    private final SignupManager signupManager;
    private final UserChecker userChecker;

    @Inject
    public ConfluenceProductLoginPageDataService(LoginPageFunctionalityService loginPageFunctionalityService, ApplicationProperties applicationProperties, I18nResolver i18nResolver, LanguageManager languageManager, SignupManager signupManager, UserChecker userChecker) {
        this.loginPageFunctionalityService = loginPageFunctionalityService;
        this.applicationProperties = applicationProperties;
        this.i18nResolver = i18nResolver;
        this.languageManager = languageManager;
        this.signupManager = signupManager;
        this.userChecker = userChecker;
    }

    @Override
    public ProductLoginPageData getLoginPageData(HttpServletRequest httpServletRequest) {
        ProductLoginPageData.Builder productLoginPageDataBuilder = ProductLoginPageData.builder().setForgotPasswordUrl(this.loginPageFunctionalityService.showForgottenPasswordHelp() ? this.getForgotPasswordPath() : null).setRememberMeType(this.loginPageFunctionalityService.shouldIncludeRememberMe() ? ProductLoginPageData.RememberMeType.SHOW_UNCHECKED : ProductLoginPageData.RememberMeType.HIDE_CHECKED).setSignupUrl(this.isShowSignUp(httpServletRequest) ? this.getSignupURL() : null).setShowLogo(false).setAuthenticationByEmail(false);
        if (Boolean.parseBoolean(httpServletRequest.getParameter("logout"))) {
            productLoginPageDataBuilder.setAdditionalSuccessMessage(this.i18nResolver.getText("successful.logout.message"));
        }
        if (this.isSignupPage(httpServletRequest)) {
            this.getSignupPermissionViolations(httpServletRequest).ifPresent(productLoginPageDataBuilder::setPermissionsViolationContext);
        }
        this.getPermissionsViolationContext(httpServletRequest).ifPresent(productLoginPageDataBuilder::setPermissionsViolationContext);
        this.getLanguageContext().ifPresent(productLoginPageDataBuilder::setLanguageContext);
        return productLoginPageDataBuilder.build();
    }

    private Optional<ProductLoginPageData.PermissionsViolationContext> getSignupPermissionViolations(HttpServletRequest httpServletRequest) {
        String token = httpServletRequest.getParameter("token");
        String message = null;
        if (!this.userChecker.isLicensedToAddMoreUsers()) {
            message = this.getSignupErrorMessage("not.licensed");
        } else if (!this.signupManager.isPublicSignupPermitted() && !this.signupManager.isDomainRestrictedSignupEnabled()) {
            if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{token})) {
                message = this.getSignupErrorMessage("public.signup.disabled");
            } else if (!this.signupManager.canSignUpWith(token)) {
                message = this.getSignupErrorMessage("signup.token.expired");
            }
        }
        if (message == null) {
            return Optional.empty();
        }
        return Optional.of(new ProductLoginPageData.PermissionsViolationContext(true, Collections.singletonList(message), Collections.emptyList()));
    }

    private Optional<ProductLoginPageData.LanguageContext> getLanguageContext() {
        List supportedLanguages = this.languageManager.getLanguages();
        List<ProductLoginPageData.Language> languages = Collections.emptyList();
        if (supportedLanguages.size() > 1) {
            HashSet seenLanguages = new HashSet();
            Set duplicatedLanguages = supportedLanguages.stream().map(Language::getLanguage).filter(otherLanguage -> !seenLanguages.add(otherLanguage)).collect(Collectors.toSet());
            languages = supportedLanguages.stream().map(language -> new ProductLoginPageData.Language(language.getName(), duplicatedLanguages.contains(language.getLanguage()) ? language.getCapitalDisplayName() : language.getCapitalDisplayLanguage())).toList();
        }
        return languages.isEmpty() ? Optional.empty() : Optional.of(new ProductLoginPageData.LanguageContext(languages));
    }

    private Optional<ProductLoginPageData.PermissionsViolationContext> getPermissionsViolationContext(HttpServletRequest httpServletRequest) {
        String originalURL;
        String userName = StringEscapeUtils.escapeHtml4((String)httpServletRequest.getRemoteUser());
        if (userName != null && (originalURL = SeraphUtils.getOriginalURL((HttpServletRequest)httpServletRequest)) != null) {
            String warningMessage = this.isValidUrl(originalURL) ? this.i18nResolver.getText("login.not.permitted.description", new Serializable[]{originalURL}) : this.i18nResolver.getText("login.not.permitted.no-url-description");
            List<String> descriptionMessages = Arrays.asList(this.i18nResolver.getText("login.logged.in", new Serializable[]{userName}), this.i18nResolver.getText("login.logged.in.description"));
            return Optional.of(new ProductLoginPageData.PermissionsViolationContext(false, Collections.singletonList(warningMessage), descriptionMessages));
        }
        return Optional.empty();
    }

    private boolean isValidUrl(String url) {
        boolean valid = this.urlValidator.isValid(url);
        if (!valid) {
            String baseUrl = this.applicationProperties.getBaseUrl(UrlMode.CANONICAL);
            return this.urlValidator.isValid(baseUrl + url);
        }
        return true;
    }

    private boolean isShowSignUp(HttpServletRequest httpServletRequest) {
        return this.loginPageFunctionalityService.isShowSignUp(httpServletRequest.getParameter("token"));
    }

    @Nonnull
    private String getForgotPasswordPath() {
        return this.applicationProperties.getBaseUrl(UrlMode.RELATIVE) + FORGOT_PASSWORD_PATH;
    }

    private String getSignupURL() {
        return this.loginPageFunctionalityService.getSignupURL();
    }

    private boolean isSignupPage(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getRequestURI().contains("signup.action") || String.valueOf(this.getRefererUrlFromTheRequest(httpServletRequest)).contains("signup.action");
    }

    private String getSignupErrorMessage(String key) {
        return this.i18nResolver.getText(key, new Serializable[]{this.applicationProperties.getBaseUrl(UrlMode.RELATIVE) + "/administrators.action"});
    }

    private String getRefererUrlFromTheRequest(HttpServletRequest request) {
        for (String attributeName : ATTRIBUTES_WHEN_FORWARDED_TO_SERVLET) {
            String url = (String)request.getAttribute(attributeName);
            if (url == null) continue;
            return url;
        }
        return null;
    }
}

