/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.loginpage;

import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.model.lookandfeel.LookAndFeelConfiguration;
import com.atlassian.crowd.service.CrowdRememberMeService;
import com.atlassian.plugins.authentication.sso.web.loginpage.ProductLoginPageData;
import com.atlassian.plugins.authentication.sso.web.loginpage.ProductLoginPageDataService;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import jakarta.servlet.http.HttpServletRequest;

public class CrowdProductLoginPageDataService
implements ProductLoginPageDataService {
    public static final String CHANGE_EXPIRED_PASSWORD_URL = "/console/changeexpiredpassword.action";
    public static final String FORGOTTEN_PASSWORD_URL = "/console/forgotlogindetails.action";
    private final CrowdRememberMeService crowdRememberMeService;
    private final ApplicationProperties applicationProperties;
    private final ApplicationFactory applicationFactory;
    private final PropertyManager propertyManager;

    public CrowdProductLoginPageDataService(ApplicationProperties applicationProperties, ApplicationFactory applicationFactory, CrowdRememberMeService crowdRememberMeService, PropertyManager propertyManager) {
        this.applicationProperties = applicationProperties;
        this.applicationFactory = applicationFactory;
        this.crowdRememberMeService = crowdRememberMeService;
        this.propertyManager = propertyManager;
    }

    @Override
    public ProductLoginPageData getLoginPageData(HttpServletRequest httpServletRequest) {
        try {
            LookAndFeelConfiguration crowdConfig = this.propertyManager.getLookAndFeelConfiguration().orElse(this.defaultLookAndFeel());
            return ProductLoginPageData.builder().setCustomButtonBackgroundColor(crowdConfig.getPrimaryColor()).setLoginHeader(crowdConfig.getHeader()).setLoginText(crowdConfig.getWelcomeText()).setShowLogo(crowdConfig.isShowLogo()).setCustomLogoUrl(this.obtainCustomLogoUrl(crowdConfig)).setCustomAnnouncementMessage(this.obtainAnnouncementText(crowdConfig)).setRememberMeType(this.rememberMeType()).setForgotPasswordUrl(this.forgottenPasswordUrl()).setChangeExpiredPasswordUrl(CHANGE_EXPIRED_PASSWORD_URL).setHideHeader(false).setAuthenticationByEmail(this.isAuthenticationByEmail()).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Error fetching properties for Crowd", e);
        }
    }

    private String obtainCustomLogoUrl(LookAndFeelConfiguration crowdConfig) {
        return crowdConfig.getCustomLogoId() != null && crowdConfig.isShowLogo() ? this.applicationProperties.getBaseUrl(UrlMode.RELATIVE) + "/logo/" + crowdConfig.getCustomLogoId() : null;
    }

    private String obtainAnnouncementText(LookAndFeelConfiguration crowdConfig) {
        return crowdConfig.isShowAnnouncement() && crowdConfig.getAnnouncementText() != null ? crowdConfig.getAnnouncementText() : null;
    }

    private LookAndFeelConfiguration defaultLookAndFeel() {
        return LookAndFeelConfiguration.builder().setHeader(null).setWelcomeText(null).setShowLogo(false).setCustomLogoId(null).setShowAnnouncement(false).setAnnouncementText(null).build();
    }

    private ProductLoginPageData.RememberMeType rememberMeType() {
        return this.crowdRememberMeService.getConfiguration().isEnabled() ? ProductLoginPageData.RememberMeType.SHOW_UNCHECKED : ProductLoginPageData.RememberMeType.HIDE_UNCHECKED;
    }

    private String forgottenPasswordUrl() {
        return this.applicationProperties.getBaseUrl(UrlMode.RELATIVE) + FORGOTTEN_PASSWORD_URL;
    }

    private boolean isAuthenticationByEmail() {
        return this.applicationFactory.getApplication().isAuthenticationViaEmailEnabled();
    }
}

