/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.loginpage;

import com.atlassian.jira.bc.security.login.LoginProperties;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.user.util.RecoveryMode;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraContactHelper;
import com.atlassian.jira.web.filters.JiraLoginInterceptor;
import com.atlassian.plugins.authentication.sso.web.loginpage.JiraContactFormUtil;
import com.atlassian.plugins.authentication.sso.web.loginpage.ProductLoginPageData;
import com.atlassian.plugins.authentication.sso.web.loginpage.ProductLoginPageDataService;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserRole;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringEscapeUtils;

public class JiraProductLoginPageDataService
implements ProductLoginPageDataService {
    private final LoginService loginService;
    private final UserManager userManager;
    private final com.atlassian.jira.config.properties.ApplicationProperties applicationProperties;
    private final RecoveryMode recoveryMode;
    private final HelpUrls helpUrls;
    private final ApplicationProperties salApplicationProperties;
    private final I18nResolver i18nResolver;
    private final JiraContactHelper jiraContactHelper;
    private final I18nHelper i18nHelper;

    @Inject
    public JiraProductLoginPageDataService(LoginService loginService, UserManager userManager, com.atlassian.jira.config.properties.ApplicationProperties applicationProperties, RecoveryMode recoveryMode, HelpUrls helpUrls, ApplicationProperties salApplicationProperties, I18nResolver i18nResolver, JiraContactHelper jiraContactHelper, I18nHelper i18nHelper) {
        this.loginService = loginService;
        this.userManager = userManager;
        this.applicationProperties = applicationProperties;
        this.recoveryMode = recoveryMode;
        this.helpUrls = helpUrls;
        this.salApplicationProperties = salApplicationProperties;
        this.i18nResolver = i18nResolver;
        this.jiraContactHelper = jiraContactHelper;
        this.i18nHelper = i18nHelper;
    }

    @Override
    public ProductLoginPageData getLoginPageData(HttpServletRequest httpServletRequest) {
        LoginProperties loginProperties = this.loginService.getLoginProperties(null, httpServletRequest);
        ProductLoginPageData.Builder loginDataBuilder = ProductLoginPageData.builder().setForgotLoginDetailsUrl(!loginProperties.isExternalUserManagement() && this.userManager.hasPasswordWritableDirectory() ? this.getForgotLoginDetailsUrl() : null).setRememberMeType(this.applicationProperties.getOption("jira.option.allowcookies") ? ProductLoginPageData.RememberMeType.SHOW_UNCHECKED : ProductLoginPageData.RememberMeType.HIDE_UNCHECKED).setSignupUrl(loginProperties.isPublicMode() ? this.getSignupUrl() : null).setRecoveryModeContext(this.recoveryMode.isRecoveryModeOn() ? new ProductLoginPageData.RecoveryModeContext((String)this.recoveryMode.getRecoveryUsername().getOrNull(), this.helpUrls.getUrl("recovery-mode").getUrl()) : null).setShowLogo(false).setAuthenticationByEmail(false);
        if (httpServletRequest.getParameter("permissionViolation") != null) {
            loginDataBuilder.setPermissionsViolationContext(this.createPermissionsViolationContextObject(httpServletRequest));
        }
        if (JiraContactFormUtil.shouldShowAdminContactLink(loginProperties, this.jiraContactHelper)) {
            loginDataBuilder.setContactAdminLink(this.jiraContactHelper.getAdministratorContactLink(httpServletRequest.getContextPath()));
        }
        return loginDataBuilder.build();
    }

    private ProductLoginPageData.PermissionsViolationContext createPermissionsViolationContextObject(HttpServletRequest httpServletRequest) {
        UserRole userRole;
        String parsedUserRole;
        String userName = StringEscapeUtils.escapeHtml4((String)httpServletRequest.getRemoteUser());
        ArrayList<String> warningMessages = new ArrayList<String>();
        if (userName != null) {
            warningMessages.add(this.i18nResolver.getText("login.required.loggedin.permissionviolation", new Serializable[]{userName}));
        }
        String string = parsedUserRole = (userRole = JiraLoginInterceptor.getUserRole((HttpServletRequest)httpServletRequest)) == null ? "" : userRole.toString();
        if ("SYSADMIN".equalsIgnoreCase(parsedUserRole)) {
            warningMessages.add(this.i18nResolver.getText("login.required.sysadmin.privileges.required"));
        } else if ("ADMIN".equalsIgnoreCase(parsedUserRole)) {
            warningMessages.add(this.i18nResolver.getText("login.required.administrator.privileges.required"));
        } else if (userName == null) {
            warningMessages.add(this.i18nResolver.getText("login.required.notloggedin.permissionviolation"));
        }
        if (userRole == null) {
            warningMessages.add(this.i18nResolver.getText("contact.admin.for.perm", new Serializable[]{this.jiraContactHelper.getAdministratorContactLinkHtml(httpServletRequest.getContextPath(), this.i18nHelper)}));
        }
        return new ProductLoginPageData.PermissionsViolationContext(true, warningMessages, Collections.emptyList());
    }

    @Nonnull
    private String getSignupUrl() {
        return this.salApplicationProperties.getBaseUrl(UrlMode.RELATIVE) + "/secure/Signup!default.jspa";
    }

    @Nonnull
    private String getForgotLoginDetailsUrl() {
        return this.salApplicationProperties.getBaseUrl(UrlMode.RELATIVE) + "/secure/ForgotLoginDetails.jspa";
    }
}

