/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.loginpage;

import com.atlassian.plugins.authentication.sso.util.JsmUrlChecker;
import com.atlassian.plugins.authentication.sso.web.loginpage.ComponentAccessorWrapper;
import com.atlassian.plugins.authentication.sso.web.loginpage.JsmProductLoginPageDataService;
import com.atlassian.plugins.authentication.sso.web.loginpage.ProductLoginPageDataService;
import com.atlassian.plugins.authentication.sso.web.loginpage.ProductLoginPageDataServiceFactory;
import com.atlassian.servicedesk.api.portal.login.PortalLoginPageDataContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraProductLoginPageDataServiceFactory
implements ProductLoginPageDataServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(JiraProductLoginPageDataServiceFactory.class);
    private final ProductLoginPageDataService productLoginPageDataService;
    private final JsmProductLoginPageDataService jsmProductLoginPageDataService;
    private final JsmUrlChecker jsmUrlChecker;
    private final ComponentAccessorWrapper componentAccessorWrapper;

    public JiraProductLoginPageDataServiceFactory(ProductLoginPageDataService productLoginPageDataService, JsmProductLoginPageDataService jsmProductLoginPageDataService, JsmUrlChecker jsmUrlChecker, ComponentAccessorWrapper componentAccessorWrapper) {
        this.productLoginPageDataService = productLoginPageDataService;
        this.jsmProductLoginPageDataService = jsmProductLoginPageDataService;
        this.jsmUrlChecker = jsmUrlChecker;
        this.componentAccessorWrapper = componentAccessorWrapper;
    }

    @Override
    public ProductLoginPageDataService getProductLoginPageDataService(String refererUrl) {
        if (this.jsmUrlChecker.isJsmRequest(refererUrl)) {
            try {
                if (this.componentAccessorWrapper.getComponent(PortalLoginPageDataContextProvider.class) != null) {
                    return this.jsmProductLoginPageDataService;
                }
            }
            catch (Exception e) {
                log.warn("Failed to access PortalLoginPageDataContextProvider when handling a JSM request, treating request as if it was made to Jira", (Throwable)e);
            }
        }
        return this.productLoginPageDataService;
    }
}

