/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.loginpage;

import com.google.common.base.MoreObjects;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ProductLoginPageData {
    @Nullable
    private final String signupUrl;
    @Nullable
    private final String forgotLoginDetailsUrl;
    @Nullable
    private final String forgotPasswordUrl;
    @Nullable
    private final String changeExpiredPasswordUrl;
    @Nullable
    private final RecoveryModeContext recoveryModeContext;
    private final boolean showLogo;
    @Nullable
    private final String customLogoUrl;
    @Nullable
    private final String customBannerImageUrl;
    @Nullable
    private final String customBannerBackgroundColor;
    @Nullable
    private final String customButtonBackgroundColor;
    @Nullable
    private final String customButtonTextColor;
    @Nullable
    private final String customAnnouncementSubject;
    @Nullable
    private final String customAnnouncementMessage;
    @Nullable
    private final String prefilledUsername;
    @Nullable
    private final String additionalSuccessMessage;
    @Nullable
    private final PermissionsViolationContext permissionsViolationContext;
    @Nullable
    private final LanguageContext languageContext;
    @Nullable
    private final String contactAdminLink;
    @Nullable
    private final String loginHeader;
    @Nullable
    private final String loginText;
    private final boolean hideHeader;
    private final boolean authenticationByEmail;
    private final RememberMeType rememberMeType;

    protected ProductLoginPageData(Builder builder) {
        this.signupUrl = builder.signupUrl;
        this.forgotLoginDetailsUrl = builder.forgotLoginDetailsUrl;
        this.forgotPasswordUrl = builder.forgotPasswordUrl;
        this.changeExpiredPasswordUrl = builder.changeExpiredPasswordUrl;
        this.recoveryModeContext = builder.recoveryModeContext;
        this.showLogo = builder.showLogo;
        this.customLogoUrl = builder.customLogoUrl;
        this.customBannerImageUrl = builder.customBannerImageUrl;
        this.customBannerBackgroundColor = builder.customBannerBackgroundColor;
        this.customButtonBackgroundColor = builder.customButtonBackgroundColor;
        this.customButtonTextColor = builder.customButtonTextColor;
        this.customAnnouncementSubject = builder.customAnnouncementSubject;
        this.customAnnouncementMessage = builder.customAnnouncementMessage;
        this.prefilledUsername = builder.prefilledUsername;
        this.additionalSuccessMessage = builder.additionalSuccessMessage;
        this.permissionsViolationContext = builder.permissionsViolationContext;
        this.languageContext = builder.languageContext;
        this.contactAdminLink = builder.contactAdminLink;
        this.loginHeader = builder.loginHeader;
        this.loginText = builder.loginText;
        this.hideHeader = builder.hideHeader;
        this.rememberMeType = Objects.requireNonNull(builder.rememberMeType);
        this.authenticationByEmail = builder.authenticationByEmail;
    }

    public Optional<String> getSignupUrl() {
        return Optional.ofNullable(this.signupUrl);
    }

    public Optional<String> getForgotLoginDetailsUrl() {
        return Optional.ofNullable(this.forgotLoginDetailsUrl);
    }

    public Optional<String> getForgotPasswordUrl() {
        return Optional.ofNullable(this.forgotPasswordUrl);
    }

    public Optional<String> getChangeExpiredPasswordUrl() {
        return Optional.ofNullable(this.changeExpiredPasswordUrl);
    }

    public Optional<RecoveryModeContext> getRecoveryModeContext() {
        return Optional.ofNullable(this.recoveryModeContext);
    }

    public boolean isShowLogo() {
        return this.showLogo;
    }

    public Optional<String> getCustomLogoUrl() {
        return Optional.ofNullable(this.customLogoUrl);
    }

    public Optional<String> getCustomBannerImageUrl() {
        return Optional.ofNullable(this.customBannerImageUrl);
    }

    public Optional<String> getCustomBannerBackgroundColor() {
        return Optional.ofNullable(this.customBannerBackgroundColor);
    }

    public Optional<String> getCustomButtonBackgroundColor() {
        return Optional.ofNullable(this.customButtonBackgroundColor);
    }

    public Optional<String> getCustomButtonTextColor() {
        return Optional.ofNullable(this.customButtonTextColor);
    }

    public Optional<String> getCustomAnnouncementSubject() {
        return Optional.ofNullable(this.customAnnouncementSubject);
    }

    public Optional<String> getCustomAnnouncementMessage() {
        return Optional.ofNullable(this.customAnnouncementMessage);
    }

    public Optional<String> getPrefilledUsername() {
        return Optional.ofNullable(this.prefilledUsername);
    }

    public Optional<String> getAdditionalSuccessMessage() {
        return Optional.ofNullable(this.additionalSuccessMessage);
    }

    public Optional<PermissionsViolationContext> getPermissionsViolationContext() {
        return Optional.ofNullable(this.permissionsViolationContext);
    }

    public Optional<LanguageContext> getLanguageContext() {
        return Optional.ofNullable(this.languageContext);
    }

    public Optional<String> getContactAdminLink() {
        return Optional.ofNullable(this.contactAdminLink);
    }

    public boolean isHideHeader() {
        return this.hideHeader;
    }

    public Optional<String> getLoginHeader() {
        return Optional.ofNullable(this.loginHeader);
    }

    public Optional<String> getLoginText() {
        return Optional.ofNullable(this.loginText);
    }

    public RememberMeType getRememberMeType() {
        return this.rememberMeType;
    }

    public boolean isAuthenticationByEmail() {
        return this.authenticationByEmail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductLoginPageData that = (ProductLoginPageData)o;
        return Objects.equals(this.getSignupUrl(), that.getSignupUrl()) && Objects.equals(this.getForgotLoginDetailsUrl(), that.getForgotLoginDetailsUrl()) && Objects.equals(this.getForgotPasswordUrl(), that.getForgotPasswordUrl()) && Objects.equals(this.getRecoveryModeContext(), that.getRecoveryModeContext()) && Objects.equals(this.getCustomLogoUrl(), that.getCustomLogoUrl()) && Objects.equals(this.getCustomBannerImageUrl(), that.getCustomBannerImageUrl()) && Objects.equals(this.getCustomBannerBackgroundColor(), that.getCustomBannerBackgroundColor()) && Objects.equals(this.getCustomButtonBackgroundColor(), that.getCustomButtonBackgroundColor()) && Objects.equals(this.getCustomButtonTextColor(), that.getCustomButtonTextColor()) && Objects.equals(this.getCustomAnnouncementSubject(), that.getCustomAnnouncementSubject()) && Objects.equals(this.getCustomAnnouncementMessage(), that.getCustomAnnouncementMessage()) && Objects.equals(this.getPermissionsViolationContext(), that.getPermissionsViolationContext()) && Objects.equals(this.getLanguageContext(), that.getLanguageContext()) && Objects.equals(this.getContactAdminLink(), that.getContactAdminLink()) && Objects.equals(this.isHideHeader(), that.isHideHeader()) && Objects.equals((Object)this.getRememberMeType(), (Object)that.getRememberMeType()) && Objects.equals(this.getAdditionalSuccessMessage(), that.getAdditionalSuccessMessage()) && Objects.equals(this.getPrefilledUsername(), that.getPrefilledUsername()) && Objects.equals(this.getLoginHeader(), that.getLoginHeader()) && Objects.equals(this.getLoginText(), that.getLoginText()) && Objects.equals(this.isAuthenticationByEmail(), that.isAuthenticationByEmail());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getSignupUrl(), this.getForgotLoginDetailsUrl(), this.getForgotPasswordUrl(), this.getRecoveryModeContext(), this.getCustomLogoUrl(), this.getCustomBannerImageUrl(), this.getCustomBannerBackgroundColor(), this.getCustomButtonBackgroundColor(), this.getCustomButtonTextColor(), this.getCustomAnnouncementSubject(), this.getCustomAnnouncementMessage(), this.getPermissionsViolationContext(), this.getLanguageContext(), this.getContactAdminLink(), this.isHideHeader(), this.getRememberMeType(), this.getPrefilledUsername(), this.getAdditionalSuccessMessage(), this.getLoginHeader(), this.getLoginText(), this.isAuthenticationByEmail()});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("signupUrl", this.getSignupUrl()).add("forgotLoginDetailsUrl", this.getForgotLoginDetailsUrl()).add("forgotPasswordUrl", this.getForgotPasswordUrl()).add("recoveryModeContext", this.getRecoveryModeContext()).add("customLogoUrl", this.getCustomLogoUrl()).add("customBannerImageUrl", this.getCustomBannerImageUrl()).add("customBannerBackgroundColor", this.getCustomBannerBackgroundColor()).add("customButtonBackgroundColor", this.getCustomButtonBackgroundColor()).add("customButtonTextColor", this.getCustomButtonTextColor()).add("customAnnouncementSubject", this.getCustomAnnouncementSubject()).add("customAnnouncementMessage", this.getCustomAnnouncementMessage()).add("permissionsViolationContext", this.getPermissionsViolationContext()).add("languageContext", this.getLanguageContext()).add("contactAdminLink", this.getContactAdminLink()).add("hideHeader", this.isHideHeader()).add("rememberMeType", (Object)this.getRememberMeType()).add("loginHeader", this.getLoginHeader()).add("loginText", this.getLoginText()).add("authenticationByEmail", this.isAuthenticationByEmail()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ProductLoginPageData data) {
        return new Builder(data);
    }

    public static final class Builder {
        private String signupUrl;
        private String forgotLoginDetailsUrl;
        private String forgotPasswordUrl;
        private String changeExpiredPasswordUrl;
        private RecoveryModeContext recoveryModeContext;
        private boolean showLogo;
        private String customLogoUrl;
        private String customBannerImageUrl;
        private String customBannerBackgroundColor;
        private String customButtonBackgroundColor;
        private String customButtonTextColor;
        private String customAnnouncementSubject;
        private String customAnnouncementMessage;
        private PermissionsViolationContext permissionsViolationContext;
        private LanguageContext languageContext;
        private String contactAdminLink;
        private boolean hideHeader;
        private RememberMeType rememberMeType;
        private String prefilledUsername;
        private String additionalSuccessMessage;
        private String loginHeader;
        private String loginText;
        private boolean authenticationByEmail;

        private Builder() {
        }

        private Builder(ProductLoginPageData initialData) {
            this.signupUrl = initialData.signupUrl;
            this.forgotLoginDetailsUrl = initialData.forgotLoginDetailsUrl;
            this.forgotPasswordUrl = initialData.forgotPasswordUrl;
            this.changeExpiredPasswordUrl = initialData.changeExpiredPasswordUrl;
            this.recoveryModeContext = initialData.recoveryModeContext;
            this.showLogo = initialData.showLogo;
            this.customLogoUrl = initialData.customLogoUrl;
            this.customBannerImageUrl = initialData.customBannerImageUrl;
            this.customBannerBackgroundColor = initialData.customBannerBackgroundColor;
            this.customButtonBackgroundColor = initialData.customButtonBackgroundColor;
            this.customButtonTextColor = initialData.customButtonTextColor;
            this.customAnnouncementSubject = initialData.customAnnouncementSubject;
            this.customAnnouncementMessage = initialData.customAnnouncementMessage;
            this.permissionsViolationContext = initialData.permissionsViolationContext;
            this.languageContext = initialData.languageContext;
            this.contactAdminLink = initialData.contactAdminLink;
            this.hideHeader = initialData.hideHeader;
            this.rememberMeType = initialData.rememberMeType;
            this.prefilledUsername = initialData.prefilledUsername;
            this.additionalSuccessMessage = initialData.additionalSuccessMessage;
            this.loginHeader = initialData.loginHeader;
            this.loginText = initialData.loginText;
            this.authenticationByEmail = initialData.authenticationByEmail;
        }

        public Builder setSignupUrl(@Nullable String signupUrl) {
            this.signupUrl = signupUrl;
            return this;
        }

        public Builder setForgotLoginDetailsUrl(@Nullable String forgotLoginDetailsUrl) {
            this.forgotLoginDetailsUrl = forgotLoginDetailsUrl;
            return this;
        }

        public Builder setForgotPasswordUrl(@Nullable String forgotPasswordUrl) {
            this.forgotPasswordUrl = forgotPasswordUrl;
            return this;
        }

        public Builder setChangeExpiredPasswordUrl(@Nullable String changeExpiredPasswordUrl) {
            this.changeExpiredPasswordUrl = changeExpiredPasswordUrl;
            return this;
        }

        public Builder setRecoveryModeContext(@Nullable RecoveryModeContext recoveryModeContext) {
            this.recoveryModeContext = recoveryModeContext;
            return this;
        }

        public Builder setShowLogo(boolean showLogo) {
            this.showLogo = showLogo;
            return this;
        }

        public Builder setCustomLogoUrl(@Nullable String customLogoUrl) {
            this.customLogoUrl = customLogoUrl;
            return this;
        }

        public Builder setCustomBannerImageUrl(@Nullable String customBannerImageUrl) {
            this.customBannerImageUrl = customBannerImageUrl;
            return this;
        }

        public Builder setCustomBannerBackgroundColor(@Nullable String customBannerBackgroundColor) {
            this.customBannerBackgroundColor = customBannerBackgroundColor;
            return this;
        }

        public Builder setCustomButtonBackgroundColor(@Nullable String customButtonBackgroundColor) {
            this.customButtonBackgroundColor = customButtonBackgroundColor;
            return this;
        }

        public Builder setCustomButtonTextColor(@Nullable String customButtonTextColor) {
            this.customButtonTextColor = customButtonTextColor;
            return this;
        }

        public Builder setCustomAnnouncementSubject(@Nullable String customAnnouncementSubject) {
            this.customAnnouncementSubject = customAnnouncementSubject;
            return this;
        }

        public Builder setCustomAnnouncementMessage(@Nullable String customAnnouncementMessage) {
            this.customAnnouncementMessage = customAnnouncementMessage;
            return this;
        }

        public Builder setPermissionsViolationContext(@Nullable PermissionsViolationContext permissionsViolationContext) {
            this.permissionsViolationContext = permissionsViolationContext;
            return this;
        }

        public Builder setLanguageContext(@Nullable LanguageContext languageContext) {
            this.languageContext = languageContext;
            return this;
        }

        public Builder setContactAdminLink(@Nullable String contactAdminLink) {
            this.contactAdminLink = contactAdminLink;
            return this;
        }

        public Builder setLoginHeader(@Nullable String loginHeader) {
            this.loginHeader = loginHeader;
            return this;
        }

        public Builder setLoginText(@Nullable String loginText) {
            this.loginText = loginText;
            return this;
        }

        public Builder setHideHeader(boolean hideHeader) {
            this.hideHeader = hideHeader;
            return this;
        }

        public Builder setRememberMeType(RememberMeType rememberMeType) {
            this.rememberMeType = rememberMeType;
            return this;
        }

        public Builder setPrefilledUsername(@Nullable String username) {
            this.prefilledUsername = username;
            return this;
        }

        public Builder setAdditionalSuccessMessage(@Nullable String successMessage) {
            this.additionalSuccessMessage = successMessage;
            return this;
        }

        public Builder setAuthenticationByEmail(boolean authenticationByEmail) {
            this.authenticationByEmail = authenticationByEmail;
            return this;
        }

        public ProductLoginPageData build() {
            return new ProductLoginPageData(this);
        }
    }

    public record RecoveryModeContext(String username, String helpLink) implements Serializable
    {
    }

    public record PermissionsViolationContext(boolean showLoginForm, List<String> warningMessages, List<String> descriptionMessages) implements Serializable
    {
    }

    public record LanguageContext(List<Language> languages) implements Serializable
    {
    }

    public static enum RememberMeType {
        SHOW_CHECKED,
        SHOW_UNCHECKED,
        HIDE_CHECKED,
        HIDE_UNCHECKED;

    }

    public record Language(String name, String displayName) implements Serializable
    {
    }
}

