/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.oidc;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugins.authentication.api.config.IdpConfig;
import com.atlassian.plugins.authentication.api.config.IdpConfigService;
import com.atlassian.plugins.authentication.api.config.JustInTimeConfig;
import com.atlassian.plugins.authentication.api.config.SsoType;
import com.atlassian.plugins.authentication.api.config.oidc.OidcConfig;
import com.atlassian.plugins.authentication.sso.option.ProductLoginOptionChecker;
import com.atlassian.plugins.authentication.sso.util.ApplicationStateValidator;
import com.atlassian.plugins.authentication.sso.web.AbstractConsumerServlet;
import com.atlassian.plugins.authentication.sso.web.AuthenticationHandler;
import com.atlassian.plugins.authentication.sso.web.AuthenticationHandlerNotConfiguredException;
import com.atlassian.plugins.authentication.sso.web.AuthenticationHandlerProvider;
import com.atlassian.plugins.authentication.sso.web.SessionData;
import com.atlassian.plugins.authentication.sso.web.SessionDataService;
import com.atlassian.plugins.authentication.sso.web.oidc.OidcAuthenticationRequest;
import com.atlassian.plugins.authentication.sso.web.oidc.OidcTimeouts;
import com.atlassian.plugins.authentication.sso.web.usercontext.AuthenticationFailedException;
import com.atlassian.plugins.authentication.sso.web.usercontext.PrincipalResolver;
import com.atlassian.plugins.authentication.sso.web.usercontext.impl.jit.ProvisioningService;
import com.atlassian.plugins.authentication.sso.web.usercontext.impl.jit.mapping.MappingExpression;
import com.atlassian.plugins.authentication.sso.web.usercontext.impl.jit.mapping.OidcUserDataFromIdpMapper;
import com.atlassian.plugins.authentication.tsv.service.session.SessionService;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.Tokens;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponseParser;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import com.nimbusds.openid.connect.sdk.validators.IDTokenClaimsVerifier;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import java.text.ParseException;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class OidcConsumerServlet
extends AbstractConsumerServlet {
    private static final Logger log = LoggerFactory.getLogger(OidcConsumerServlet.class);
    public static final String CALLBACK_URL = "/plugins/servlet/oidc/callback";
    private static final String MAX_CLOCK_SKEW_PROPERTY_NAME = "com.atlassian.plugins.authentication.impl.web.oidc.OidcConsumerServlet.maxClockSkewSeconds";
    private static final Duration MAX_CLOCK_SKEW = Optional.ofNullable(System.getProperty("com.atlassian.plugins.authentication.impl.web.oidc.OidcConsumerServlet.maxClockSkewSeconds")).map(Integer::parseInt).map(Duration::ofSeconds).orElse(Duration.ofSeconds(60L));
    private final AuthenticationHandlerProvider authenticationHandlerProvider;
    private final OidcUserDataFromIdpMapper mapper;
    private final OidcTimeouts oidcTimeouts;
    private final ApplicationProperties applicationProperties;

    public OidcConsumerServlet(IdpConfigService idpConfigService, AuthenticationHandlerProvider authenticationHandlerProvider, PrincipalResolver principalResolver, SessionDataService sessionDataService, AuthenticationListener authenticationListener, I18nResolver i18nResolver, ApplicationStateValidator applicationStateValidator, ProvisioningService provisioningService, ProductLoginOptionChecker productLoginOptionChecker, OidcUserDataFromIdpMapper mapper, OidcTimeouts oidcTimeouts, SessionService sessionService, ApplicationProperties applicationProperties) {
        super(principalResolver, sessionDataService, authenticationListener, i18nResolver, applicationStateValidator, idpConfigService, provisioningService, productLoginOptionChecker, sessionService);
        this.authenticationHandlerProvider = authenticationHandlerProvider;
        this.mapper = mapper;
        this.oidcTimeouts = oidcTimeouts;
        this.applicationProperties = applicationProperties;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Principal resolvedPrincipal;
        AuthenticationSuccessResponse successResponse = this.parseResponse(request);
        SessionData sessionData = this.sessionDataService.getSessionData(request, response, successResponse.getState().getValue()).orElseThrow(() -> new AuthenticationFailedException("Unknown state in response"));
        OidcConfig oidcConfig = this.fetchOidcConfigFromSession(sessionData);
        this.applicationStateValidator.checkCanProcessAuthenticationRequest((IdpConfig)oidcConfig);
        OIDCTokens tokens = this.getOidcTokens(successResponse, oidcConfig);
        String username = this.getUsername(tokens, sessionData, oidcConfig);
        Optional<Principal> principal = Optional.empty();
        JustInTimeConfig jitConfig = oidcConfig.getJustInTimeConfig();
        if (!this.applicationProperties.getPlatformId().equals("crowd") && jitConfig.isEnabled().orElse(false).booleanValue()) {
            this.provisioningService.handleJustInTimeProvisioning(this.mapper.mapUser(tokens, username, oidcConfig));
        }
        if (!this.principalResolver.isAllowedToAuthenticate(resolvedPrincipal = principal.orElseGet(() -> this.principalResolver.resolvePrincipal(username).orElseThrow(() -> new AuthenticationFailedException("Received SSO request for user " + username + ", but the user does not exist"))), request)) {
            throw new AuthenticationFailedException("Received SSO request for user " + username + ", but the user is not permitted to log in");
        }
        String redirectUrl = this.sessionDataService.extractTargetUrlOrReturnBaseUrl(Optional.of(sessionData));
        this.productLoginOptionChecker.checkIdpLoginOptionApplicable(username, (IdpConfig)oidcConfig, redirectUrl);
        this.authenticationSuccess(request, response, resolvedPrincipal, SessionService.AuthenticationType.OIDC, oidcConfig.isEnableRememberMe());
        log.debug("Authenticated user {} from IDP with ID '{}', redirecting to {}", new Object[]{resolvedPrincipal.getName(), oidcConfig.getId(), redirectUrl});
        response.sendRedirect(redirectUrl);
    }

    private String getUsername(OIDCTokens tokens, SessionData sessionData, OidcConfig oidcConfig) {
        Preconditions.checkState((boolean)(sessionData.getAuthenticationRequest() instanceof OidcAuthenticationRequest));
        OidcAuthenticationRequest request = (OidcAuthenticationRequest)sessionData.getAuthenticationRequest();
        try {
            JWTClaimsSet jwtClaimsSet = tokens.getIDToken().getJWTClaimsSet();
            new IDTokenClaimsVerifier(new Issuer(oidcConfig.getIssuer()), new ClientID(oidcConfig.getClientId()), Nonce.parse((String)request.getNonce()), (int)MAX_CLOCK_SKEW.getSeconds()).verify(jwtClaimsSet, null);
            String rawExpression = Strings.isNullOrEmpty((String)oidcConfig.getUsernameClaim()) ? "${sub}" : oidcConfig.getUsernameClaim();
            MappingExpression usernameClaimExpression = new MappingExpression(rawExpression);
            return usernameClaimExpression.evaluateWithValues(varName -> this.getUsernameFromCustomClaim(oidcConfig, tokens, jwtClaimsSet, (String)varName));
        }
        catch (BadJWTException | ParseException e) {
            throw new AuthenticationFailedException("ID token parsing failed", e);
        }
    }

    @Nonnull
    private OIDCTokens getOidcTokens(AuthenticationSuccessResponse successResponse, OidcConfig oidcConfig) {
        TokenRequest tokenRequest = this.prepareTokenRequest(successResponse.getAuthorizationCode(), oidcConfig);
        return this.exchangeAuthorizationCodeForTokens(tokenRequest);
    }

    private AuthenticationSuccessResponse parseResponse(HttpServletRequest request) {
        try {
            AuthenticationResponse authResp = AuthenticationResponseParser.parse((URI)URI.create(request.getRequestURL().toString()), (Map)Maps.transformValues((Map)request.getParameterMap(), ImmutableList::copyOf));
            if (authResp.indicatesSuccess()) {
                return authResp.toSuccessResponse();
            }
            throw this.toException("Error when fetching authorization response", authResp.toErrorResponse().getErrorObject());
        }
        catch (com.nimbusds.oauth2.sdk.ParseException e) {
            throw new AuthenticationFailedException("Parsing authentication response failed", e);
        }
    }

    private OidcConfig fetchOidcConfigFromSession(SessionData sessionData) {
        return (OidcConfig)OidcConfig.from((IdpConfig)this.idpConfigService.getIdpConfig(Long.valueOf(sessionData.getIdpConfigId()))).orElseThrow(() -> new AuthenticationHandlerNotConfiguredException("Session IDP Config is not OIDC in OIDC callback"));
    }

    @Nonnull
    @VisibleForTesting
    OIDCTokens exchangeAuthorizationCodeForTokens(TokenRequest tokenReq) {
        try {
            HTTPRequest httpRequest = tokenReq.toHTTPRequest();
            httpRequest.setConnectTimeout(this.oidcTimeouts.getConnectTimeoutInMillis());
            httpRequest.setReadTimeout(this.oidcTimeouts.getReadTimeoutInMillis());
            HTTPResponse tokenHTTPResp = httpRequest.send();
            if (tokenHTTPResp.getStatusCode() == 200) {
                return OIDCTokenResponse.parse((HTTPResponse)tokenHTTPResp).getOIDCTokens();
            }
            ErrorObject oidcErrorObject = TokenErrorResponse.parse((HTTPResponse)tokenHTTPResp).getErrorObject();
            if (oidcErrorObject.getCode() == null && oidcErrorObject.getDescription() == null) {
                log.debug("Received invalid response when exchanging authorization tokens: {}", (Object)tokenHTTPResp.getContent());
            }
            throw this.toException("Exchanging authorization tokens failed", oidcErrorObject);
        }
        catch (com.nimbusds.oauth2.sdk.ParseException | SerializeException | IOException e) {
            throw new AuthenticationFailedException("Exchanging authorization tokens failed.", e);
        }
    }

    private String getUsernameFromCustomClaim(OidcConfig oidcConfig, OIDCTokens tokens, JWTClaimsSet jwtClaimsSet, String usernameClaim) {
        String usernameFromIdToken;
        try {
            log.debug("Looking for a username in ID token by checking custom claim [{}]", (Object)usernameClaim);
            usernameFromIdToken = jwtClaimsSet.getStringClaim(usernameClaim);
        }
        catch (ParseException e) {
            throw new AuthenticationFailedException("ID token parsing failed", e);
        }
        if (Strings.isNullOrEmpty((String)usernameFromIdToken)) {
            log.debug("Custom claim with a username in ID token not found. Request to the userinfo endpoint will be sent.");
            return this.getUsernameFromUserInfoEndpoint((Tokens)tokens, usernameClaim, oidcConfig.getUserInfoEndpoint());
        }
        return usernameFromIdToken;
    }

    @Nonnull
    private String getUsernameFromUserInfoEndpoint(Tokens tokens, String usernameClaim, String userInfoEndpoint) {
        URI userInfoUri = URI.create(userInfoEndpoint);
        UserInfoRequest userInfoReq = new UserInfoRequest(userInfoUri, (BearerAccessToken)tokens.getAccessToken());
        UserInfoSuccessResponse userInfoResponse = this.getUserInfoResponse(userInfoReq);
        JSONObject claims = userInfoResponse.getUserInfo().toJSONObject();
        String username = claims.getAsString(usernameClaim);
        if (Strings.isNullOrEmpty((String)username)) {
            log.debug("Couldn't find claim representing username [{}] within the set of claims returned from userinfo endpoint: {}", (Object)usernameClaim, (Object)claims.keySet());
            throw new AuthenticationFailedException("Couldn't find claim representing username");
        }
        return username;
    }

    @Nonnull
    @VisibleForTesting
    UserInfoSuccessResponse getUserInfoResponse(UserInfoRequest userInfoReq) {
        try {
            HTTPRequest httpRequest = userInfoReq.toHTTPRequest();
            httpRequest.setReadTimeout(this.oidcTimeouts.getReadTimeoutInMillis());
            httpRequest.setConnectTimeout(this.oidcTimeouts.getConnectTimeoutInMillis());
            HTTPResponse userInfoHTTPResp = httpRequest.send();
            UserInfoResponse userInfoResponse = UserInfoResponse.parse((HTTPResponse)userInfoHTTPResp);
            if (userInfoResponse.indicatesSuccess()) {
                return userInfoResponse.toSuccessResponse();
            }
            throw this.toException("Error when fetching data from userinfo endpoint", userInfoResponse.toErrorResponse().getErrorObject());
        }
        catch (com.nimbusds.oauth2.sdk.ParseException | SerializeException | IOException e) {
            throw new AuthenticationFailedException("Error when fetching data from userinfo endpoint");
        }
    }

    private AuthenticationFailedException toException(String message, ErrorObject errorObject) {
        return new AuthenticationFailedException(message + ". Error: " + errorObject.toJSONObject().toString());
    }

    @Nonnull
    private TokenRequest prepareTokenRequest(AuthorizationCode authCode, OidcConfig ssoConfig) {
        URI tokenEndpoint = URI.create(ssoConfig.getTokenEndpoint());
        ClientID clientID = new ClientID(ssoConfig.getClientId());
        Secret clientSecret = new Secret(ssoConfig.getClientSecret());
        ClientSecretBasic clientInfo = new ClientSecretBasic(clientID, clientSecret);
        AuthorizationCodeGrant authorizationCodeGrant = new AuthorizationCodeGrant(authCode, this.getRedirectUri());
        return new TokenRequest(tokenEndpoint, (ClientAuthentication)clientInfo, (AuthorizationGrant)authorizationCodeGrant);
    }

    @Nonnull
    private URI getRedirectUri() {
        AuthenticationHandler authenticationHandler = this.authenticationHandlerProvider.getAuthenticationHandler(SsoType.OIDC);
        return URI.create(authenticationHandler.getConsumerServletUrl());
    }
}

