/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.saml;

import com.atlassian.plugins.authentication.api.config.saml.SamlConfig;
import com.atlassian.plugins.authentication.sso.util.ApplicationStateValidator;
import com.atlassian.plugins.authentication.sso.util.TargetUrlNormalizer;
import com.atlassian.plugins.authentication.sso.web.AbstractAuthenticationHandler;
import com.atlassian.plugins.authentication.sso.web.AuthenticationRequest;
import com.atlassian.plugins.authentication.sso.web.SessionDataService;
import com.atlassian.plugins.authentication.sso.web.saml.provider.SamlProvider;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class SamlAuthenticationHandler
extends AbstractAuthenticationHandler<SamlConfig> {
    private final SamlProvider samlProvider;

    public SamlAuthenticationHandler(ApplicationProperties applicationProperties, ApplicationStateValidator applicationStateValidator, SamlProvider samlProvider, SessionDataService sessionDataService, SoyTemplateRenderer soyTemplateRenderer, WebResourceUrlProvider webResourceUrlProvider, TargetUrlNormalizer targetUrlNormalizer) {
        super(applicationProperties, applicationStateValidator, sessionDataService, targetUrlNormalizer, webResourceUrlProvider, soyTemplateRenderer);
        this.samlProvider = samlProvider;
    }

    @Override
    @Nonnull
    public String getConsumerServletUrl() {
        return StringUtils.removeEnd((String)this.getIssuerUrl(), (String)"/") + "/plugins/servlet/samlconsumer";
    }

    @Override
    protected AuthenticationRequest prepareAuthenticationRequest(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, SamlConfig samlConfig) {
        return this.samlProvider.createSamlSingleSignOnRequest(request, response, this.getServiceProviderInfo(), this.isPermissionViolation(request), samlConfig);
    }

    private SamlProvider.ServiceProviderInfo getServiceProviderInfo() {
        return new SamlProvider.ServiceProviderInfo(this.getIssuerUrl(), this.getConsumerServletUrl());
    }
}

