/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.saml.certificate.impl;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.plugins.authentication.sso.rest.exception.KeyCertificatePairCurrentlyGeneratingException;
import com.atlassian.plugins.authentication.sso.rest.model.KeyCertificatePair;
import com.atlassian.plugins.authentication.sso.web.saml.certificate.SamlSpKeyCertificatePairStore;

public class CachingSamlSpKeyCertificatePairStore
implements SamlSpKeyCertificatePairStore {
    private final SamlSpKeyCertificatePairStore delegate;
    private final CachedReference<KeyCertificatePair> cachedKeyCertificatePair;
    private final ClusterLock lock;

    public CachingSamlSpKeyCertificatePairStore(SamlSpKeyCertificatePairStore delegate, CacheManager cacheManager, ClusterLockService clusterLockService) {
        this.delegate = delegate;
        this.cachedKeyCertificatePair = cacheManager.getCachedReference(CachingSamlSpKeyCertificatePairStore.class.getName(), delegate::readKeyPairAndCert, new CacheSettingsBuilder().remote().replicateViaInvalidation().build());
        this.lock = clusterLockService.getLockForName(this.getClass().getName() + ".KEY_CERTIFICATE_PAIR_LOCK");
    }

    @Override
    public KeyCertificatePair readKeyPairAndCert() {
        return (KeyCertificatePair)this.cachedKeyCertificatePair.get();
    }

    @Override
    public void storeKeyPairAndCert(KeyCertificatePair keyCertificatePair) {
        if (this.lock.tryLock()) {
            try {
                this.delegate.storeKeyPairAndCert(keyCertificatePair);
                this.cachedKeyCertificatePair.reset();
            }
            finally {
                this.lock.unlock();
            }
        } else {
            throw new KeyCertificatePairCurrentlyGeneratingException("Cannot generate a new key-certificate pair as the key-certificate pair is currently being replaced.");
        }
    }
}

