/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.saml.certificate.impl;

import com.atlassian.plugins.authentication.encryption.EncryptionConfigurationService;
import com.atlassian.plugins.authentication.sso.rest.exception.KeyCertificatePairConfigurationException;
import com.atlassian.plugins.authentication.sso.rest.model.KeyCertificatePair;
import com.atlassian.plugins.authentication.sso.web.saml.certificate.SamlSpKeyCertificatePairStore;
import com.atlassian.plugins.authentication.sso.web.saml.certificate.util.KeyCertificatePairConversionUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.Provider;

public class FileBasedSamlSpKeyCertificatePairStore
implements SamlSpKeyCertificatePairStore {
    private static final String KEYPAIR_FILE_NAME = "saml-key-and-certificate.pem";
    private final Provider securityProvider;
    private final EncryptionConfigurationService encryptionConfigurationService;

    public FileBasedSamlSpKeyCertificatePairStore(Provider securityProvider, EncryptionConfigurationService encryptionConfigurationService) {
        this.securityProvider = securityProvider;
        this.encryptionConfigurationService = encryptionConfigurationService;
    }

    @Override
    public void storeKeyPairAndCert(KeyCertificatePair keyCertificatePair) {
        Path keyDirectory = this.encryptionConfigurationService.getKeyDirectory();
        Path keyPairPath = keyDirectory.resolve(KEYPAIR_FILE_NAME);
        String pairAsPem = this.convertPairToPem(keyCertificatePair);
        try {
            Files.writeString(keyPairPath, (CharSequence)pairAsPem, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new KeyCertificatePairConfigurationException("Could not store key pair", e);
        }
    }

    @Override
    public KeyCertificatePair readKeyPairAndCert() {
        Path keyDirectory = this.encryptionConfigurationService.getKeyDirectory();
        Path keyPairPath = keyDirectory.resolve(KEYPAIR_FILE_NAME);
        return this.pemStringToKeyCertificatePair(keyPairPath.toString());
    }

    private String convertPairToPem(KeyCertificatePair keyCertificatePair) {
        return KeyCertificatePairConversionUtil.convertPairToPem(keyCertificatePair);
    }

    private KeyCertificatePair pemStringToKeyCertificatePair(String keyAndCertificatePairPath) {
        return KeyCertificatePairConversionUtil.pemStringToKeyCertificatePair(keyAndCertificatePairPath, this.securityProvider);
    }
}

