/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.saml.certificate.impl;

import com.atlassian.plugins.authentication.sso.rest.model.KeyCertificatePair;
import com.atlassian.plugins.authentication.sso.web.saml.certificate.SamlSpKeyCertificatePairService;
import com.atlassian.plugins.authentication.sso.web.saml.certificate.SamlSpKeyCertificatePairStore;
import com.atlassian.plugins.authentication.sso.web.saml.certificate.impl.CertificateAndPrivateKeyGenerator;

public class SamlSpKeyCertificatePairServiceImpl
implements SamlSpKeyCertificatePairService {
    private final CertificateAndPrivateKeyGenerator certificateAndPrivateKeyGenerator;
    private final SamlSpKeyCertificatePairStore samlSpKeyCertificatePairStore;

    public SamlSpKeyCertificatePairServiceImpl(CertificateAndPrivateKeyGenerator certificateAndPrivateKeyGenerator, SamlSpKeyCertificatePairStore samlSpKeyCertificatePairStore) {
        this.certificateAndPrivateKeyGenerator = certificateAndPrivateKeyGenerator;
        this.samlSpKeyCertificatePairStore = samlSpKeyCertificatePairStore;
    }

    @Override
    public KeyCertificatePair generateCertificateAndPrivateKey() {
        KeyCertificatePair keyCertificatePair = this.certificateAndPrivateKeyGenerator.generateCertificateAndPrivateKey();
        this.samlSpKeyCertificatePairStore.storeKeyPairAndCert(keyCertificatePair);
        return keyCertificatePair;
    }

    @Override
    public KeyCertificatePair getKeyCertificatePair() {
        return this.samlSpKeyCertificatePairStore.readKeyPairAndCert();
    }
}

