/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.saml.certificate.util;

import com.atlassian.plugins.authentication.sso.rest.exception.KeyCertificatePairConfigurationException;
import com.atlassian.plugins.authentication.sso.rest.model.KeyCertificatePair;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public final class KeyCertificatePairConversionUtil {
    private KeyCertificatePairConversionUtil() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static KeyCertificatePair pemStringToKeyCertificatePair(String keyAndCertificatePairPath, Provider securityProvider) {
        try (FileReader reader = new FileReader(keyAndCertificatePairPath);){
            KeyCertificatePair keyCertificatePair;
            try (PEMParser pemParser = new PEMParser((Reader)reader);){
                PEMKeyPair pemKeyPair = (PEMKeyPair)pemParser.readObject();
                JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter();
                jcaPEMKeyConverter.setProvider(securityProvider);
                PrivateKey privateKey = jcaPEMKeyConverter.getPrivateKey(pemKeyPair.getPrivateKeyInfo());
                X509CertificateHolder certificate = (X509CertificateHolder)pemParser.readObject();
                JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter();
                jcaX509CertificateConverter.setProvider(securityProvider);
                X509Certificate cer = jcaX509CertificateConverter.getCertificate(certificate);
                keyCertificatePair = new KeyCertificatePair(privateKey, cer);
            }
            return keyCertificatePair;
        }
        catch (FileNotFoundException e) {
            throw new KeyCertificatePairConfigurationException("Keypair file does not exist", e);
        }
        catch (PEMException e) {
            throw new KeyCertificatePairConfigurationException("Private key parsing failed", e);
        }
        catch (IOException e) {
            throw new KeyCertificatePairConfigurationException("Unexpected error when reading keypair file", e);
        }
        catch (CertificateException e) {
            throw new KeyCertificatePairConfigurationException("Certificate parsing failed", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String convertPairToPem(KeyCertificatePair keyCertificatePair) {
        try (StringWriter writer = new StringWriter();){
            String string;
            try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);){
                pemWriter.writeObject((Object)keyCertificatePair.privateKey());
                pemWriter.writeObject((Object)keyCertificatePair.certificate());
                pemWriter.flush();
                string = writer.toString();
            }
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert pem key to string.", e);
        }
    }
}

