/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.saml.provider.impl;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.plugin.classloader.DelegationClassLoader;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.util.ContextClassLoaderSwitchingUtil;
import com.atlassian.plugins.authentication.api.config.saml.NameIdPolicy;
import com.atlassian.plugins.authentication.api.config.saml.SamlConfig;
import com.atlassian.plugins.authentication.common.properties.AuthenticationPluginFeatureInternalService;
import com.atlassian.plugins.authentication.sso.rest.model.KeyCertificatePair;
import com.atlassian.plugins.authentication.sso.util.ValidationUtils;
import com.atlassian.plugins.authentication.sso.web.AuthenticationHandlerNotConfiguredException;
import com.atlassian.plugins.authentication.sso.web.saml.certificate.SamlSpKeyCertificatePairService;
import com.atlassian.plugins.authentication.sso.web.saml.provider.InvalidSamlResponse;
import com.atlassian.plugins.authentication.sso.web.saml.provider.SamlProvider;
import com.atlassian.plugins.authentication.sso.web.saml.provider.SamlRequest;
import com.atlassian.plugins.authentication.sso.web.saml.provider.SamlResponse;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.onelogin.saml2.Auth;
import com.onelogin.saml2.authn.AuthnRequest;
import com.onelogin.saml2.authn.AuthnRequestParams;
import com.onelogin.saml2.exception.SettingsException;
import com.onelogin.saml2.servlet.ServletUtils;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.settings.SettingsBuilder;
import io.atlassian.util.adapter.javax.JavaXAdapters;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Instant;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;

public class OneloginJavaSamlProvider
implements SamlProvider {
    protected static final String SIGNATURE_ALGORITHM_QUERY_PARAM_KEY = "SigAlg";
    protected static final String SIGNATURE_QUERY_PARAM_KEY = "Signature";
    private final SamlSpKeyCertificatePairService samlSpKeyCertificatePairService;
    private final AuthenticationPluginFeatureInternalService authenticationPluginFeatureInternalService;

    public OneloginJavaSamlProvider(SamlSpKeyCertificatePairService samlSpKeyCertificatePairService, AuthenticationPluginFeatureInternalService authenticationPluginFeatureInternalService) {
        this.samlSpKeyCertificatePairService = samlSpKeyCertificatePairService;
        this.authenticationPluginFeatureInternalService = authenticationPluginFeatureInternalService;
    }

    @Override
    public SamlRequest createSamlSingleSignOnRequest(@Nonnull jakarta.servlet.http.HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull SamlProvider.ServiceProviderInfo serviceProviderInfo, boolean forceAuth, SamlConfig samlConfig) {
        try {
            Auth auth = this.createAuthForAuthnRequest(request, response, serviceProviderInfo, samlConfig);
            Saml2Settings settings = auth.getSettings();
            AuthnRequest authnRequest = new AuthnRequest(settings, new AuthnRequestParams(forceAuth, false, NameIdPolicy.safeGet((NameIdPolicy)samlConfig.getNameIdPolicy()) != NameIdPolicy.NONE && this.authenticationPluginFeatureInternalService.isSamlAuthRequestsSigningEnabled()));
            String samlRequest = authnRequest.getEncodedAuthnRequest();
            try {
                UriBuilder uriBuilder = UriBuilder.fromUri((URI)settings.getIdpSingleSignOnServiceUrl().toURI());
                if (!Strings.isNullOrEmpty((String)samlRequest)) {
                    uriBuilder.queryParam("SAMLRequest", new Object[]{samlRequest});
                }
                String relayState = UUID.randomUUID().toString();
                uriBuilder.queryParam("RelayState", new Object[]{relayState});
                if (settings.getAuthnRequestsSigned()) {
                    this.signAuthenticationRequest(auth, settings, samlRequest, uriBuilder, relayState);
                }
                return new SamlRequest(authnRequest.getId(), uriBuilder.build(new Object[0]).toString(), relayState);
            }
            catch (SettingsException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void signAuthenticationRequest(Auth auth, Saml2Settings settings, String samlRequest, UriBuilder uriBuilder, String relayState) throws SettingsException {
        String signatureAlgorithm = settings.getSignatureAlgorithm();
        String signature = auth.buildRequestSignature(samlRequest, relayState, signatureAlgorithm);
        uriBuilder.queryParam(SIGNATURE_ALGORITHM_QUERY_PARAM_KEY, new Object[]{signatureAlgorithm});
        uriBuilder.queryParam(SIGNATURE_QUERY_PARAM_KEY, new Object[]{signature});
    }

    @Override
    public SamlResponse extractSamlResponse(@Nonnull jakarta.servlet.http.HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull SamlProvider.ServiceProviderInfo serviceProviderInfo, @Nonnull SamlConfig samlConfig, @Nullable SamlRequest samlRequest) throws InvalidSamlResponse {
        try {
            return (SamlResponse)ContextClassLoaderSwitchingUtil.runInContext((ClassLoader)((Object)new ServiceOverridingClassLoader()), () -> {
                Auth auth = this.createAuthForSamlResponse(request, response, serviceProviderInfo, samlConfig);
                try {
                    auth.processResponse(samlRequest == null ? null : samlRequest.getId());
                }
                catch (Exception e) {
                    throw new InvalidSamlResponse(e);
                }
                if (!auth.isAuthenticated()) {
                    throw new InvalidSamlResponse("Received invalid SAML response: " + auth.getLastErrorReason());
                }
                return new SamlResponse(auth.getNameId(), auth.getAttributes(), auth.getLastAssertionId(), auth.getLastAssertionNotOnOrAfter().stream().map(jodaInstant -> Instant.ofEpochMilli(jodaInstant.getMillis())).collect(Collectors.toList()));
            });
        }
        catch (InvalidSamlResponse e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> getIssuers(jakarta.servlet.http.HttpServletRequest request) {
        try {
            return (List)ContextClassLoaderSwitchingUtil.runInContext((ClassLoader)((Object)new ServiceOverridingClassLoader()), () -> new com.onelogin.saml2.authn.SamlResponse(new Saml2Settings(), ServletUtils.makeHttpRequest((HttpServletRequest)JavaXAdapters.asJavaX((jakarta.servlet.http.HttpServletRequest)request))).getIssuers());
        }
        catch (Exception e) {
            throw new InvalidSamlResponse("Received invalid SAML response", e);
        }
    }

    private Auth createAuthForAuthnRequest(jakarta.servlet.http.HttpServletRequest request, HttpServletResponse response, SamlProvider.ServiceProviderInfo serviceProviderInfo, SamlConfig samlConfig) {
        Saml2Settings samlSettings = this.createSettingsForAuthnRequest(serviceProviderInfo, samlConfig);
        return this.createAuth(request, response, samlSettings);
    }

    private Auth createAuthForSamlResponse(jakarta.servlet.http.HttpServletRequest request, HttpServletResponse response, SamlProvider.ServiceProviderInfo serviceProviderInfo, SamlConfig samlConfig) {
        Saml2Settings samlSettings = this.createSettingsForSamlResponse(serviceProviderInfo, samlConfig);
        return this.createAuth(request, response, samlSettings);
    }

    private Auth createAuth(jakarta.servlet.http.HttpServletRequest request, HttpServletResponse response, Saml2Settings samlSettings) {
        try {
            return new Auth(samlSettings, JavaXAdapters.asJavaX((jakarta.servlet.http.HttpServletRequest)request), JavaXAdapters.asJavaX((HttpServletResponse)response));
        }
        catch (SettingsException e) {
            throw new AuthenticationHandlerNotConfiguredException("Invalid SAML configuration", (Exception)((Object)e));
        }
    }

    @VisibleForTesting
    private Saml2Settings createSettingsForAuthnRequest(SamlProvider.ServiceProviderInfo serviceProviderInfo, SamlConfig samlConfig) {
        HashMap<String, Object> propertiesBuilder = new HashMap<String, Object>();
        this.setCommonSamlSettings(serviceProviderInfo, samlConfig, propertiesBuilder);
        if (this.authenticationPluginFeatureInternalService.isSamlAuthRequestsSigningEnabled()) {
            NameIdPolicy nameIdPolicy;
            if (samlConfig.isSignAuthnRequest() && samlConfig.getIdpType() == SamlConfig.IdpType.GENERIC && this.authenticationPluginFeatureInternalService.isSamlAuthRequestsSigningEnabled()) {
                KeyCertificatePair keyCertificatePair = this.samlSpKeyCertificatePairService.getKeyCertificatePair();
                propertiesBuilder.put("onelogin.saml2.sp.privatekey", keyCertificatePair.privateKey());
                propertiesBuilder.put("onelogin.saml2.sp.x509cert", keyCertificatePair.certificate());
                propertiesBuilder.put("onelogin.saml2.security.authnrequest_signed", true);
                propertiesBuilder.put("onelogin.saml2.security.signature_algorithm", samlConfig.getSignatureAlgorithm().getAlgorithmUrl());
            }
            if (!Objects.equals(nameIdPolicy = NameIdPolicy.safeGet((NameIdPolicy)samlConfig.getNameIdPolicy()), NameIdPolicy.NONE)) {
                propertiesBuilder.put("onelogin.saml2.sp.nameidformat", nameIdPolicy.getSamlConstantName());
            }
        }
        return new SettingsBuilder().fromValues(propertiesBuilder).build();
    }

    private Saml2Settings createSettingsForSamlResponse(SamlProvider.ServiceProviderInfo serviceProviderInfo, SamlConfig samlConfig) {
        HashMap<String, Object> propertiesBuilder = new HashMap<String, Object>();
        this.setCommonSamlSettings(serviceProviderInfo, samlConfig, propertiesBuilder);
        return new SettingsBuilder().fromValues(propertiesBuilder).build();
    }

    private void setCommonSamlSettings(SamlProvider.ServiceProviderInfo serviceProviderInfo, SamlConfig samlConfig, Map<String, Object> propertiesBuilder) {
        propertiesBuilder.put("onelogin.saml2.strict", true);
        propertiesBuilder.put("onelogin.saml2.security.want_assertions_encrypted", false);
        propertiesBuilder.put("onelogin.saml2.security.want_assertions_signed", true);
        propertiesBuilder.put("onelogin.saml2.security.reject_unsolicited_responses_with_inresponseto", true);
        propertiesBuilder.put("onelogin.saml2.sp.entityid", serviceProviderInfo.getIssuerUrl());
        propertiesBuilder.put("onelogin.saml2.sp.assertion_consumer_service.url", ValidationUtils.convertToUrl(serviceProviderInfo.getConsumerServiceUrl()));
        propertiesBuilder.put("onelogin.saml2.idp.entityid", samlConfig.getIssuer());
        propertiesBuilder.put("onelogin.saml2.idp.single_sign_on_service.url", ValidationUtils.convertToUrl(samlConfig.getSsoUrl()));
        propertiesBuilder.put("onelogin.saml2.idp.x509cert", ValidationUtils.convertToCertificate(samlConfig.getCertificate()));
    }

    private static class ServiceOverridingClassLoader
    extends DelegationClassLoader {
        private static final Set<String> OVERRIDDEN_SERVICE_RESOURCES = ImmutableSet.of((Object)"META-INF/services/javax.xml.validation.SchemaFactory", (Object)"META-INF/services/javax.xml.xpath.XPathFactory", (Object)"META-INF/services/javax.xml.parsers.DocumentBuilderFactory");

        private ServiceOverridingClassLoader() {
            this.setDelegateClassLoader(HostContainer.class.getClassLoader());
        }

        public Enumeration<URL> getResources(String name) throws IOException {
            if (OVERRIDDEN_SERVICE_RESOURCES.contains(name)) {
                return this.findResources(name);
            }
            return super.getResources(name);
        }
    }
}

