/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.usercontext.impl.jit;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.plugins.authentication.sso.license.ProductLicenseChecker;
import com.atlassian.plugins.authentication.sso.web.usercontext.impl.jit.JitCrowdUser;
import com.atlassian.plugins.authentication.sso.web.usercontext.impl.jit.JitException;
import com.atlassian.plugins.authentication.sso.web.usercontext.impl.jit.mapping.JitUserData;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserProvisioningService {
    private static final Logger log = LoggerFactory.getLogger(UserProvisioningService.class);
    private final DarkFeatureManager darkFeatureManager;
    private final ProductLicenseChecker productLicenseChecker;
    private final DirectoryManager directoryManager;

    public UserProvisioningService(DarkFeatureManager darkFeatureManager, ProductLicenseChecker productLicenseChecker, DirectoryManager directoryManager) {
        this.darkFeatureManager = darkFeatureManager;
        this.productLicenseChecker = productLicenseChecker;
        this.directoryManager = directoryManager;
    }

    public JitCrowdUser provisionUser(JitUserData userData, Directory jitDirectory) {
        log.debug("Attempting to JIT provision unrecognized user [{}]", (Object)userData.getUsername());
        try {
            if (!this.darkFeatureManager.isEnabledForAllUsers("atlassian.authentication.sso.jit.disable.license.check").orElse(false).booleanValue() && !this.productLicenseChecker.areSlotsAvailable((Set<String>)userData.getGroups())) {
                log.error("Did not provision user [{}] as license limit would have been exceeded", (Object)userData.getUsername());
                throw new JitException("User could not be created due to the license\u2019s limit.");
            }
            UserTemplateWithAttributes user = new UserTemplateWithAttributes((com.atlassian.crowd.embedded.api.UserWithAttributes)new JitCrowdUser(userData, jitDirectory.getId()));
            UserWithAttributes createdUser = this.directoryManager.addUser(jitDirectory.getId().longValue(), user, this.createPasswordForProvisionedUser());
            return new JitCrowdUser(userData.getIdentityProviderId(), (User)createdUser);
        }
        catch (InvalidCredentialException | InvalidUserException | OperationFailedException | UserAlreadyExistsException | DirectoryPermissionException e) {
            log.error("Provisioning user [{}] by JIT failed", (Object)userData.getUsername(), (Object)e);
            throw new JitException(e);
        }
        catch (DirectoryNotFoundException e) {
            log.error("JIT provisioning of user [{}] failed due to missing directory", (Object)userData.getUsername(), (Object)e);
            throw new ConcurrentModificationException(e);
        }
    }

    public JitCrowdUser updateUser(JitUserData userData, JitCrowdUser existingUser) {
        log.debug("Attempting to update JIT user [{}]", (Object)userData.getUsername());
        try {
            JitCrowdUser user = existingUser;
            if (!userData.getIdentityProviderId().equals(existingUser.getValue("jit_idp_id"))) {
                this.directoryManager.storeUserAttributes(user.getDirectoryId(), user.getName(), (Map)ImmutableMap.of((Object)"jit_idp_id", Collections.singleton(userData.getIdentityProviderId())));
            }
            if (!userData.getUsername().equals(user.getName())) {
                log.debug("Renaming JIT user [{}] to [{}]", (Object)user.getName(), (Object)userData.getUsername());
                user = this.directoryManager.renameUser(user.getDirectoryId(), user.getName(), userData.getUsername());
            }
            if (!userData.getDisplayName().equals(user.getDisplayName()) || !userData.getEmail().equals(user.getEmailAddress())) {
                UserTemplate updatedUserTemplate = new UserTemplate((User)user);
                updatedUserTemplate.setDisplayName(userData.getDisplayName());
                updatedUserTemplate.setEmailAddress(userData.getEmail());
                user = this.directoryManager.updateUser(user.getDirectoryId(), updatedUserTemplate);
            }
            return new JitCrowdUser(userData.getIdentityProviderId(), (User)user);
        }
        catch (InvalidUserException | OperationFailedException | UserAlreadyExistsException | UserNotFoundException | DirectoryPermissionException e) {
            log.error("Updating user [{}] by JIT failed", (Object)userData.getUsername());
            throw new JitException(e);
        }
        catch (DirectoryNotFoundException e) {
            log.error("The directory [{}] was not found when updating user [{}]", new Object[]{existingUser.getDirectoryId(), userData.getUsername(), e});
            throw new ConcurrentModificationException(e);
        }
    }

    private PasswordCredential createPasswordForProvisionedUser() {
        if (this.darkFeatureManager.isEnabledForAllUsers("atlassian.authentication.sso.jit.legacy.password.generation").orElse(false).booleanValue()) {
            return new PasswordCredential(String.valueOf(UUID.randomUUID()) + "ABab23!");
        }
        return PasswordCredential.NONE;
    }
}

