/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.sso.web.usercontext.rememberme;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.service.CrowdRememberMeService;
import com.atlassian.plugins.authentication.sso.web.usercontext.rememberme.RememberMeCookieHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdRememberMeCookieHandler
implements RememberMeCookieHandler {
    private static final Logger log = LoggerFactory.getLogger(CrowdRememberMeCookieHandler.class);
    private final CrowdRememberMeService crowdRememberMeService;

    public CrowdRememberMeCookieHandler(CrowdRememberMeService crowdRememberMeService) {
        this.crowdRememberMeService = crowdRememberMeService;
    }

    @Override
    public void refreshRememberMeCookie(HttpServletRequest request, HttpServletResponse response, Principal user) {
        if (!(user instanceof User)) {
            log.warn("Cannot create remember me cookie for non-Crowd user {}", (Object)user.getName());
            return;
        }
        User crowdUser = (User)user;
        this.crowdRememberMeService.removeCookie(request, response);
        this.crowdRememberMeService.createCookie(crowdUser, request, response);
    }
}

