/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.db;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugins.authentication.tsv.db.model.TotpCodes;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TotpCodesDao {
    private final ActiveObjects ao;
    private static final Logger log = LoggerFactory.getLogger(TotpCodesDao.class);

    public TotpCodesDao(ActiveObjects ao) {
        this.ao = ao;
    }

    public boolean totpCodeExistForUser(@Nonnull String userKey, @Nonnull String totpCode) {
        int codesSize = this.ao.count(TotpCodes.class, Query.select().where(String.format("%s = ? AND %s = ?", "TOTP_CODE_HASH", "USER_KEY"), new Object[]{totpCode, userKey}));
        return codesSize >= 1;
    }

    public void saveTotpCodeForUser(@Nonnull String totpCode, @Nonnull String userKey, @Nonnull Instant expiryTimestamp) {
        this.ao.executeInTransaction(() -> {
            this.ao.create(TotpCodes.class, new DBParam[]{new DBParam("TOTP_CODE_HASH", (Object)totpCode), new DBParam("USER_KEY", (Object)userKey), new DBParam("EXPIRY_TIMESTAMP", (Object)expiryTimestamp.toEpochMilli())});
            return null;
        });
        log.debug("Saved TOTP code for user {}, expires on {}", (Object)userKey, (Object)expiryTimestamp);
    }

    public void removeExpiredBefore(@Nonnull Instant timestamp) {
        this.ao.executeInTransaction(() -> {
            int removed = this.ao.deleteWithSQL(TotpCodes.class, "EXPIRY_TIMESTAMP <= ?", new Object[]{timestamp.toEpochMilli()});
            log.debug("Deleted {} TOTP codes older than {}", (Object)removed, (Object)timestamp);
            return null;
        });
    }
}

