/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.job;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.plugins.authentication.tsv.service.EnrollmentCleanupService;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrollmentCleanupJob
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(EnrollmentCleanupJob.class);
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)EnrollmentCleanupJob.class.getCanonicalName());
    private static final JobId JOB_ID = JobId.of((String)"2sv-enrollment-cleanup-job");
    private static final String ENROLLMENT_CLEANUP_JOB_INTERVAL_HOURS_PROPERTY = "atlassian.authentication.2sv.enroll.cleanup.job.interval.hours";
    private static final Duration DEFAULT_INTERVAL = Duration.ofHours(24L);
    private final SchedulerService schedulerService;
    private final EnrollmentCleanupService enrollmentCleanupService;

    public EnrollmentCleanupJob(SchedulerService schedulerService, EnrollmentCleanupService enrollmentCleanupService) {
        this.schedulerService = schedulerService;
        this.enrollmentCleanupService = enrollmentCleanupService;
    }

    @PostConstruct
    public void registerJob() throws SchedulerServiceException {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        Date nextRun = Date.from(Instant.now().plus(this.getIntervalInHours(), ChronoUnit.HOURS));
        Schedule schedule = Schedule.forInterval((long)TimeUnit.HOURS.toMillis(this.getIntervalInHours()), (Date)nextRun);
        this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(schedule));
        log.debug("Scheduled 2sv enrollment cleanup job ({}), next run at {}", (Object)JOB_ID, (Object)nextRun);
    }

    @PreDestroy
    public void unregisterJob() {
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
        log.debug("Unregistered 2sv enrollment cleanup job");
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        try {
            log.debug("Starting 2sv enrollment cleanup job");
            this.enrollmentCleanupService.deleteEnrollmentsForDeletedUsers();
            log.debug("Finished 2sv enrollment cleanup job");
            return JobRunnerResponse.success();
        }
        catch (Exception e) {
            log.error("Failed to complete 2sv enrollment cleanup job", (Throwable)e);
            return JobRunnerResponse.failed((Throwable)e);
        }
    }

    @VisibleForTesting
    protected long getIntervalInHours() {
        return Long.getLong(ENROLLMENT_CLEANUP_JOB_INTERVAL_HOURS_PROPERTY, DEFAULT_INTERVAL.toHours());
    }
}

