/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.rest;

import com.atlassian.dc.swagger.annotations.BasePathDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.authentication.api.tsv.internal.annotation.DisabledInLegacyMode;
import com.atlassian.plugins.authentication.api.tsv.internal.exception.InvalidRecoveryCodeException;
import com.atlassian.plugins.authentication.api.tsv.internal.exception.InvalidTotpCodeException;
import com.atlassian.plugins.authentication.api.tsv.internal.service.AuthAuditService;
import com.atlassian.plugins.authentication.api.tsv.internal.service.RecoveryCodeService;
import com.atlassian.plugins.authentication.api.tsv.internal.service.VerificationMethod;
import com.atlassian.plugins.authentication.captcha.CaptchaService;
import com.atlassian.plugins.authentication.captcha.model.CaptchaDataEntity;
import com.atlassian.plugins.authentication.sso.option.ProductLoginOptionChecker;
import com.atlassian.plugins.authentication.tsv.auth.callback.FailedLoginAttemptCallback;
import com.atlassian.plugins.authentication.tsv.exception.ConversationNotFoundException;
import com.atlassian.plugins.authentication.tsv.exception.LoginFormNotApplicableException;
import com.atlassian.plugins.authentication.tsv.exception.LoginFormNotAvailableException;
import com.atlassian.plugins.authentication.tsv.model.AuthenticationEntity;
import com.atlassian.plugins.authentication.tsv.model.AuthenticationResponse;
import com.atlassian.plugins.authentication.tsv.model.ConversationType;
import com.atlassian.plugins.authentication.tsv.model.LoginResult;
import com.atlassian.plugins.authentication.tsv.model.TotpRecoveryCodeDTO;
import com.atlassian.plugins.authentication.tsv.rest.NextLoginStep;
import com.atlassian.plugins.authentication.tsv.rest.model.CredentialsCheckFailedDTO;
import com.atlassian.plugins.authentication.tsv.rest.model.NextLoginStepDTO;
import com.atlassian.plugins.authentication.tsv.rest.model.TotpCodeVerificationDTO;
import com.atlassian.plugins.authentication.tsv.rest.model.TotpRecoveryCodeAuthenticationDTO;
import com.atlassian.plugins.authentication.tsv.rest.model.conversation.LoginConversation;
import com.atlassian.plugins.authentication.tsv.rest.model.conversation.TotpEnrollConversation;
import com.atlassian.plugins.authentication.tsv.service.EnrollmentService;
import com.atlassian.plugins.authentication.tsv.service.InternalRecoveryCodeService;
import com.atlassian.plugins.authentication.tsv.service.TotpConversationService;
import com.atlassian.plugins.authentication.tsv.service.TotpLoginService;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.AuthenticationFailedResponseBuilder;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.CredentialVerificationException;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.CredentialVerificationService;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.model.FailedLoginResponseContext;
import com.atlassian.plugins.authentication.tsv.service.credentialverification.model.SuccessfulCredentialVerificationResult;
import com.atlassian.plugins.authentication.tsv.service.enforcement.EnforcementService;
import com.atlassian.plugins.authentication.tsv.service.session.SessionService;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.atlassian.sal.api.user.UserKey;
import io.atlassian.fugue.Either;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/authenticate")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@UnrestrictedAccess
@DisabledInLegacyMode
@BasePathDoc(value="/tsv/latest")
@Tag(name="Authentication")
public class AuthenticationResource {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationResource.class);
    private final ProductLoginOptionChecker productLoginOptionChecker;
    private final EnrollmentService enrollmentService;
    private final SessionService sessionService;
    private final TotpLoginService totpLoginService;
    private final TotpConversationService totpConversationService;
    private final InternalRecoveryCodeService recoveryCodeService;
    private final CredentialVerificationService credentialVerificationService;
    private final CaptchaService captchaService;
    private final FailedLoginAttemptCallback failedLoginAttemptCallback;
    private final AuthAuditService authAuditService;
    private final EnforcementService enforcementService;
    private final AuthenticationFailedResponseBuilder authenticationFailedResponseBuilder;

    @Inject
    public AuthenticationResource(ProductLoginOptionChecker productLoginOptionChecker, EnrollmentService enrollmentService, SessionService sessionService, TotpConversationService totpConversationService, InternalRecoveryCodeService recoveryCodeService, TotpLoginService totpLoginService, CredentialVerificationService credentialVerificationService, CaptchaService captchaService, FailedLoginAttemptCallback failedLoginAttemptCallback, AuthAuditService authAuditService, EnforcementService enforcementService, AuthenticationFailedResponseBuilder authenticationFailedResponseBuilder) {
        this.productLoginOptionChecker = productLoginOptionChecker;
        this.enrollmentService = enrollmentService;
        this.sessionService = sessionService;
        this.totpConversationService = totpConversationService;
        this.recoveryCodeService = recoveryCodeService;
        this.totpLoginService = totpLoginService;
        this.credentialVerificationService = credentialVerificationService;
        this.captchaService = captchaService;
        this.failedLoginAttemptCallback = failedLoginAttemptCallback;
        this.authAuditService = authAuditService;
        this.enforcementService = enforcementService;
        this.authenticationFailedResponseBuilder = authenticationFailedResponseBuilder;
    }

    @Operation(description="Authenticates as the given user. This endpoint <strong>may</strong>:\n\n- Ask for two-step verification if the user has enrolled; or\n- Enforce enrollment in two-step verification if two-step verification enforcement is configured for the instance and the user is not yet enrolled.", summary="Authenticate with 2SV")
    @RequestBody(content={@Content(schema=@Schema(implementation=AuthenticationEntity.class))})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="The user has successfully authenticated.", representation=AuthenticationResponse.class), @ResponseDoc(responseCode=401, documentation="The given user failed authentication.", representation=CredentialsCheckFailedDTO.class), @ResponseDoc(responseCode=412, documentation="The user must undergo additional verification or enroll in two-step verification in order to authenticate", representation=NextLoginStepDTO.class)})
    @POST
    public Response authenticate(AuthenticationEntity authenticationEntity, @Context HttpServletRequest request, @Context HttpServletResponse response) throws LoginFormNotApplicableException, LoginFormNotAvailableException {
        SuccessfulCredentialVerificationResult result;
        boolean captchaChallenge;
        if (!this.productLoginOptionChecker.isLoginFormLoginPossible()) {
            throw new LoginFormNotAvailableException();
        }
        if (this.captchaService.isCaptchaRequired(authenticationEntity.getUsername()) && !(captchaChallenge = this.captchaService.isValid(authenticationEntity.getCaptchaId(), authenticationEntity.getCaptchaChallenge()))) {
            log.debug("Failed captcha challenge for user with username : {}", (Object)authenticationEntity.getUsername());
            this.failedLoginAttemptCallback.onFailure(request, authenticationEntity.getUsername(), FailedLoginAttemptCallback.FailureType.CAPTCHA_MISMATCH);
            return this.authenticationFailedResponseBuilder.generateCaptchaCheckFailedResponse();
        }
        try {
            result = this.credentialVerificationService.verifyCredentials(request, response, authenticationEntity.getUsername(), authenticationEntity.getPassword());
        }
        catch (CredentialVerificationException e) {
            log.debug("Failed to authenticate user with username : {}", (Object)authenticationEntity.getUsername(), (Object)e);
            LoginResult loginResult = e.getLoginResult();
            boolean userCredentialsExpired = loginResult.equals((Object)LoginResult.USER_CREDENTIALS_EXPIRED);
            this.failedLoginAttemptCallback.onFailure(request, authenticationEntity.getUsername(), userCredentialsExpired ? FailedLoginAttemptCallback.FailureType.CREDENTIALS_EXPIRED : FailedLoginAttemptCallback.FailureType.CREDENTIALS_MISMATCH);
            return this.authenticationFailedResponseBuilder.generateLoginFailedResponse(new FailedLoginResponseContext(request, loginResult, this.captchaService.isCaptchaRequired(authenticationEntity.getUsername()), userCredentialsExpired));
        }
        UserKey userKey = result.userKey();
        this.productLoginOptionChecker.checkLoginFormOptionApplicable(userKey, authenticationEntity.getTargetUrl());
        boolean alreadyEnrolled = this.enrollmentService.isAlreadyEnrolled(userKey.getStringValue());
        if (alreadyEnrolled) {
            String conversationId = this.totpLoginService.startLoginConversation(userKey.getStringValue(), authenticationEntity.getUsername(), authenticationEntity.getRememberMe(), result.crowdSsoCookieData()).getConversationId();
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)new NextLoginStepDTO(conversationId, NextLoginStep.TOTP_CODE_VERIFICATION)).build();
        }
        if (this.enforcementService.isEnforcementRequired(userKey)) {
            TotpEnrollConversation conversation = this.enrollmentService.startEnforcedEnrollmentConversation(userKey.getStringValue(), authenticationEntity.getUsername(), authenticationEntity.getRememberMe(), result.crowdSsoCookieData());
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)new NextLoginStepDTO(conversation.getConversationId(), NextLoginStep.ENROLLMENT)).build();
        }
        this.sessionService.createNewSession(request, response, result.user(), authenticationEntity.getRememberMe(), SessionService.AuthenticationType.LOGIN_FORM, result.crowdSsoCookieData());
        this.authAuditService.logUserLoginViaLoginFormWithout2SV(userKey);
        return Response.ok((Object)new AuthenticationResponse(authenticationEntity.getTargetUrl())).build();
    }

    @Operation(description="Authenticate as the given user using a TOTP code.", summary="Authenticate using TOTP code")
    @RequestBody(description="A request containing a TOTP code for the given user.", content={@Content(schema=@Schema(implementation=TotpCodeVerificationDTO.class))})
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="The user was successfully logged in."), @ResponseDoc(responseCode=400, documentation="The requested conversation cannot be found or is not valid in the requested context.", restError=true), @ResponseDoc(responseCode=401, documentation="The TOTP code provided was incorrect.", restError=true)})
    @POST
    @Path(value="/totp-code")
    public Response verifyCode(TotpCodeVerificationDTO totpCodeVerificationDTO, @Context HttpServletRequest request, @Context HttpServletResponse response) throws ConversationNotFoundException, InvalidTotpCodeException {
        this.totpLoginService.completeLoginUsingTotpVerification(totpCodeVerificationDTO.getConversationId(), totpCodeVerificationDTO.getTotpCode(), request, response);
        return Response.noContent().build();
    }

    @Operation(description="Authenticate as the given user using a recovery code.", summary="Authenticate using recovery code")
    @RequestBody(description="A request containing a recovery code for the specified user.", content={@Content(schema=@Schema(implementation=TotpRecoveryCodeAuthenticationDTO.class))})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="The user was successfully logged in.", representation=AuthenticationResponse.class), @ResponseDoc(responseCode=400, documentation="The requested conversation cannot be found or is not valid in the requested context.", restError=true), @ResponseDoc(responseCode=401, documentation="The recovery code provided was incorrect.", restError=true)})
    @POST
    @Path(value="/recovery-code")
    public Response authenticateWithRecoveryCode(TotpRecoveryCodeAuthenticationDTO recoveryCodeDTO, @Context HttpServletRequest request, @Context HttpServletResponse response) throws ConversationNotFoundException {
        LoginConversation conversation = this.totpConversationService.retrieveLoginConversation(recoveryCodeDTO.getConversationId()).orElseThrow(() -> new ConversationNotFoundException(ConversationType.AUTHENTICATION));
        String userKey = conversation.getUserKey();
        String username = conversation.getUserName();
        Either responseOrError = this.recoveryCodeService.useRecoveryCode(userKey, username, recoveryCodeDTO.getRecoveryCode()).map(code -> {
            log.debug("User {} provided matching recovery code, authenticating", (Object)username);
            this.totpConversationService.invalidateLoginConversation(recoveryCodeDTO.getConversationId());
            this.sessionService.createNewSession(request, response, userKey, conversation.getRememberMe(), SessionService.AuthenticationType.LOGIN_FORM, conversation.getCrowdSsoCookieData());
            this.authAuditService.logTsvLoginSuccess(new UserKey(userKey), VerificationMethod.RECOVERY_KEY);
            return Response.ok((Object)new TotpRecoveryCodeDTO(code)).build();
        }).leftMap(error -> {
            this.authAuditService.logTsvLoginFailure(new UserKey(userKey), VerificationMethod.RECOVERY_KEY);
            return switch (error) {
                default -> throw new MatchException(null, null);
                case RecoveryCodeService.RecoveryCodeConsumptionError.USER_NOT_ENROLLED -> new IllegalStateException("Cannot find enrollment for user " + username);
                case RecoveryCodeService.RecoveryCodeConsumptionError.RECOVERY_CODE_INVALID -> new InvalidRecoveryCodeException();
            };
        });
        return (Response)responseOrError.getOrThrow(() -> (RuntimeException)responseOrError.left().get());
    }

    @Operation(description="Provides data for a CAPTCHA challenge.", summary="Get CAPTCHA challenge")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="The CAPTCHA challenge", representation=CaptchaDataEntity.class)})
    @GET
    @Path(value="/captcha")
    public CaptchaDataEntity getCaptchaData(@Context HttpServletRequest request) {
        return this.captchaService.getCaptchaData(request);
    }
}

