/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.rest;

import com.atlassian.annotations.security.UnlicensedSiteAccess;
import com.atlassian.dc.swagger.annotations.BasePathDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.authentication.api.tsv.internal.annotation.DisabledInLegacyMode;
import com.atlassian.plugins.authentication.tsv.exception.ElevationMeansIncorrectException;
import com.atlassian.plugins.authentication.tsv.exception.SessionElevationRequiredException;
import com.atlassian.plugins.authentication.tsv.model.ActionType;
import com.atlassian.plugins.authentication.tsv.model.ElevationMethodRestDTO;
import com.atlassian.plugins.authentication.tsv.model.PasswordElevationRestDTO;
import com.atlassian.plugins.authentication.tsv.model.TotpElevationRestDTO;
import com.atlassian.plugins.authentication.tsv.model.TotpRecoveryCodeDTO;
import com.atlassian.plugins.authentication.tsv.service.ElevatedSessionService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@Path(value="/elevate-permissions")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@BasePathDoc(value="/tsv/latest")
@Tag(name="Authentication")
@DisabledInLegacyMode
@UnlicensedSiteAccess
public class ElevatedSessionResource {
    private final ElevatedSessionService elevatedSessionService;

    @Inject
    public ElevatedSessionResource(ElevatedSessionService elevatedSessionService) {
        this.elevatedSessionService = elevatedSessionService;
    }

    @Operation(description="Checks the state of an elevated session for the currently authenticated user.", summary="Get elevated session status")
    @Parameters(value={@Parameter(description="The type of action being performed.", in=ParameterIn.QUERY, name="actionType", schema=@Schema(allowableValues={"unlock-user-2sv-settings"}))})
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="An elevated session exists for the currently authenticated user."), @ResponseDoc(responseCode=401, documentation="The currently authenticated user requires an elevated session to perform this request.", representation=ElevationMethodRestDTO.class)})
    @GET
    public Response getElevatedPermissionStatus(@QueryParam(value="actionType") ActionType actionType, @Context HttpServletRequest request) throws SessionElevationRequiredException {
        this.elevatedSessionService.checkElevatedSession(actionType, request);
        return Response.noContent().build();
    }

    @Operation(description="Elevate permissions by providing a TOTP code for the currently authenticated user. This will create an elevated session.", summary="Create elevated session with TOTP")
    @Parameters(value={@Parameter(description="The type of action being performed.", in=ParameterIn.QUERY, name="actionType", schema=@Schema(allowableValues={"unlock-user-2sv-settings"}))})
    @RequestBody(description="A request containing a TOTP code for the given user.", content={@Content(schema=@Schema(implementation=TotpElevationRestDTO.class))})
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="Permissions were successfully elevated."), @ResponseDoc(responseCode=400, documentation="One of the following error cases occurred (check the error message for more details).\n\n- The user has entered an incorrect TOTP code\n- The requested action cannot be confirmed with a TOTP code\n- The user is not enrolled in two-step verification\n", restError=true), @ResponseDoc(responseCode=403, documentation="The user cannot perform the requested action.")})
    @POST
    @Path(value="/totp")
    public Response elevatePermissionsWithTotp(@QueryParam(value="actionType") ActionType actionType, TotpElevationRestDTO totpElevationRestDTO, @Context HttpServletRequest request, @Context HttpServletResponse response) throws ElevationMeansIncorrectException {
        this.elevatedSessionService.elevateSessionUsingTotpCode(actionType, totpElevationRestDTO.getTotpCode(), request, response);
        return Response.noContent().build();
    }

    @Operation(description="Elevate permissions by providing the password for the currently authenticated user. This will create an elevated session.", summary="Create elevated session with password")
    @Parameters(value={@Parameter(description="The type of action being performed.", in=ParameterIn.QUERY, name="actionType", schema=@Schema(allowableValues={"unlock-user-2sv-settings"}))})
    @RequestBody(description="A request containing the password for the currently authenticated user.", content={@Content(schema=@Schema(implementation=TotpElevationRestDTO.class))})
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="Permissions were successfully elevated."), @ResponseDoc(responseCode=400, documentation="The user has entered an incorrect password or the requested action cannot be confirmed with a password.", restError=true), @ResponseDoc(responseCode=403, documentation="The user cannot perform the requested action.")})
    @POST
    @Path(value="/password")
    public Response elevatePermissionsWithPassword(@QueryParam(value="actionType") ActionType actionType, PasswordElevationRestDTO passwordElevationRestDTO, @Context HttpServletRequest request, @Context HttpServletResponse response) throws ElevationMeansIncorrectException {
        this.elevatedSessionService.elevateSessionUsingPassword(actionType, passwordElevationRestDTO.getPassword(), request, response);
        return Response.noContent().build();
    }

    @Operation(description="Elevate permissions by providing a recovery code for the currently authenticated user. This will create an elevated session.", summary="Create elevated session with recovery code")
    @Parameters(value={@Parameter(description="The type of action being performed.", in=ParameterIn.QUERY, name="actionType", schema=@Schema(allowableValues={"unlock-user-2sv-settings"}))})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Permissions were successfully elevated.", representation=TotpRecoveryCodeDTO.class), @ResponseDoc(responseCode=400, documentation="The recovery code provided was incorrect.", restError=true), @ResponseDoc(responseCode=403, documentation="The user cannot perform the requested action.")})
    @RequestBody(description="A request containing a recovery code for the currently authenticated user.", content={@Content(schema=@Schema(implementation=TotpRecoveryCodeDTO.class))})
    @POST
    @Path(value="/recovery-code")
    public TotpRecoveryCodeDTO elevatePermissionsWithRecoveryCode(@QueryParam(value="actionType") ActionType actionType, TotpRecoveryCodeDTO recoveryCodeDTO, @Context HttpServletRequest request, @Context HttpServletResponse response) throws ElevationMeansIncorrectException {
        String newRecoveryCode = this.elevatedSessionService.elevateSessionUsingRecoveryCode(actionType, recoveryCodeDTO.getRecoveryCode(), request, response);
        return new TotpRecoveryCodeDTO(newRecoveryCode);
    }
}

