/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.rest;

import com.atlassian.annotations.security.UnlicensedSiteAccess;
import com.atlassian.dc.swagger.annotations.BasePathDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.authentication.api.tsv.internal.annotation.DisabledInLegacyMode;
import com.atlassian.plugins.authentication.encryption.EncryptionService;
import com.atlassian.plugins.authentication.encryption.model.SealedSecret;
import com.atlassian.plugins.authentication.encryption.model.Secret;
import com.atlassian.plugins.authentication.tsv.exception.ConversationNotFoundException;
import com.atlassian.plugins.authentication.tsv.exception.DecryptionFailedException;
import com.atlassian.plugins.authentication.tsv.exception.SessionElevationRequiredException;
import com.atlassian.plugins.authentication.tsv.model.ActionType;
import com.atlassian.plugins.authentication.tsv.model.ConversationType;
import com.atlassian.plugins.authentication.tsv.model.ElevationMethodRestDTO;
import com.atlassian.plugins.authentication.tsv.model.TotpRecoveryCodeDTO;
import com.atlassian.plugins.authentication.tsv.model.TotpUserEnrollment;
import com.atlassian.plugins.authentication.tsv.rest.model.TotpCodeVerificationDTO;
import com.atlassian.plugins.authentication.tsv.rest.model.TotpUserEnrollmentDTO;
import com.atlassian.plugins.authentication.tsv.rest.model.conversation.ConversationDTO;
import com.atlassian.plugins.authentication.tsv.rest.model.conversation.TotpEnrollConversation;
import com.atlassian.plugins.authentication.tsv.service.ElevatedSessionService;
import com.atlassian.plugins.authentication.tsv.service.EnrollmentService;
import com.atlassian.plugins.authentication.tsv.service.TotpConversationService;
import com.atlassian.plugins.authentication.tsv.service.session.SessionService;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.atlassian.fugue.Pair;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/totp")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@BasePathDoc(value="/tsv/latest")
@Tag(name="Authentication")
@DisabledInLegacyMode
@UnlicensedSiteAccess
public class EnrollmentResource {
    private static final Logger log = LoggerFactory.getLogger(EnrollmentResource.class);
    private final TotpConversationService totpConversationService;
    private final EnrollmentService enrollmentService;
    private final ElevatedSessionService elevatedSessionService;
    private final SessionService sessionService;
    private final EncryptionService encryptionService;

    @Inject
    public EnrollmentResource(TotpConversationService totpConversationService, EnrollmentService enrollmentService, ElevatedSessionService elevatedSessionService, SessionService sessionService, EncryptionService encryptionService) {
        this.totpConversationService = totpConversationService;
        this.enrollmentService = enrollmentService;
        this.elevatedSessionService = elevatedSessionService;
        this.sessionService = sessionService;
        this.encryptionService = encryptionService;
    }

    @Operation(description="Start voluntary enrollment in two-step verification by creating a conversation.\n\nThere are two ways to enroll in two-step verification: voluntary and enforced. Enrollment is a two-step process. First, the user starts the enrollment process via <code>/start-voluntary-enrollment</code> or <code>/start-enforced-enrollment</code>. Second and final step is to complete the enrollment via <code>/complete-voluntary-enrollment</code> or <code>/complete-enforced-enrollment</code>. In the case of enforced enrollment, the conversation is started at the time of login via <code>/authenticate</code>.", summary="Start voluntary enrollment in 2SV")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="A conversation has successfully started.", representation=TotpUserEnrollmentDTO.class), @ResponseDoc(responseCode=400, documentation="The user is already enrolled in two-step verification using TOTP.", restError=true), @ResponseDoc(responseCode=401, documentation="The currently authenticated user requires an elevated session to perform this request.", representation=ElevationMethodRestDTO.class)})
    @POST
    @Path(value="/start-voluntary-enrollment")
    public TotpUserEnrollmentDTO startVoluntaryEnrollment(@Context HttpServletRequest request) throws SessionElevationRequiredException {
        this.elevatedSessionService.checkElevatedSession(ActionType.UNLOCK_USER_2SV_SETTINGS, request);
        TotpEnrollConversation conversation = this.enrollmentService.startVoluntaryEnrollmentConversation();
        log.debug("Returning response for voluntary conversation for user-key {}", (Object)conversation.getUserKey());
        return this.mapToTotpUserEnrollmentDTO(conversation);
    }

    @Operation(description="Start the process of changing the authentication app used for two-step verification by creating a conversation.", summary="Start authentication app update for 2SV")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="A conversation has successfully started.", representation=TotpUserEnrollmentDTO.class), @ResponseDoc(responseCode=400, documentation="The user is not enrolled in two-step verification using TOTP.", restError=true), @ResponseDoc(responseCode=401, documentation="The currently authenticated user requires an elevated session to perform this request.", representation=ElevationMethodRestDTO.class)})
    @POST
    @Path(value="/start-enrollment-update")
    public TotpUserEnrollmentDTO startEnrollmentUpdate(@Context HttpServletRequest request) throws SessionElevationRequiredException {
        this.elevatedSessionService.checkElevatedSession(ActionType.UNLOCK_USER_2SV_SETTINGS, request);
        TotpEnrollConversation conversation = this.enrollmentService.startChangeAuthenticationAppConversation();
        log.debug("Returning response for change authentication app conversation for user-key {}", (Object)conversation.getUserKey());
        return this.mapToTotpUserEnrollmentDTO(conversation);
    }

    @Operation(description="Start or resume enforced enrollment in two-step verification by returning the conversation details.\n\nThere are two ways to enroll in two-step verification: voluntary and enforced. Enrollment is a two-step process. First, the user starts the enrollment process via <code>/start-voluntary-enrollment</code> or <code>/start-enforced-enrollment</code>. Second and final step is to complete the enrollment via <code>/complete-voluntary-enrollment</code> or <code>/complete-enforced-enrollment</code>. In the case of enforced enrollment, the conversation is started at the time of login via <code>/authenticate</code>.", summary="Start enforced enrollment in 2SV")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="A conversation has successfully started.", representation=TotpUserEnrollmentDTO.class), @ResponseDoc(responseCode=400, documentation="The requested enrollment conversation cannot be found or is not valid in the requested context.", restError=true)})
    @POST
    @UnrestrictedAccess
    @Path(value="/start-enforced-enrollment")
    public TotpUserEnrollmentDTO startEnforcedEnrollment(ConversationDTO conversationDTO) throws ConversationNotFoundException {
        TotpEnrollConversation conversation = this.totpConversationService.retrieveEnrollConversation(conversationDTO.getConversationId()).orElseThrow(() -> new ConversationNotFoundException(ConversationType.ENFORCED_ENROLLMENT));
        log.debug("Returning response for enforced conversation for username {}", (Object)conversation.getUserName());
        return this.mapToTotpUserEnrollmentDTO(conversation);
    }

    @Operation(description="Complete enforced enrollment in two-step verification by verifying the provided TOTP code and creating a new session for the given user.", summary="Complete enforced enrollment in 2SV")
    @RequestBody(description="A request containing a TOTP code for the given user.", content={@Content(schema=@Schema(implementation=TotpCodeVerificationDTO.class))})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Enrollment successfully completed.", representation=TotpRecoveryCodeDTO.class), @ResponseDoc(responseCode=400, documentation="The requested enrollment conversation cannot be found or the user is already enrolled in two-step verification.", restError=true)})
    @POST
    @UnrestrictedAccess
    @Path(value="/complete-enforced-enrollment")
    public TotpRecoveryCodeDTO completeEnforcedEnrollment(TotpCodeVerificationDTO verificationRequest, @Context HttpServletRequest request, @Context HttpServletResponse response) throws ConversationNotFoundException {
        Pair<TotpUserEnrollment, TotpEnrollConversation> enrollment = this.enrollmentService.completeEnforcedEnrollment(verificationRequest.getConversationId(), verificationRequest.getTotpCode());
        this.sessionService.createNewSession(request, response, ((TotpUserEnrollment)enrollment.left()).userKey(), ((TotpEnrollConversation)enrollment.right()).getRememberMe(), SessionService.AuthenticationType.LOGIN_FORM, ((TotpEnrollConversation)enrollment.right()).getCrowdSsoCookieData());
        log.debug("Completion of Enforced enrollment completed");
        return new TotpRecoveryCodeDTO(((TotpUserEnrollment)enrollment.left()).recoveryCode());
    }

    @Operation(description="Complete voluntary enrollment in two-step verification by verifying the provided TOTP code and creating a new session for the given user.", summary="Complete voluntary enrollment in 2SV")
    @RequestBody(description="A request containing a TOTP code for the given user.", content={@Content(schema=@Schema(implementation=TotpCodeVerificationDTO.class))})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Enrollment successfully completed.", representation=TotpUserEnrollmentDTO.class), @ResponseDoc(responseCode=400, documentation="The requested enrollment conversation cannot be found or the user is already enrolled in two-step verification.", restError=true), @ResponseDoc(responseCode=401, documentation="The currently authenticated user requires an elevated session to perform this request.", representation=ElevationMethodRestDTO.class)})
    @POST
    @Path(value="/complete-voluntary-enrollment")
    public TotpRecoveryCodeDTO completeVoluntaryEnrollment(TotpCodeVerificationDTO verificationRequest, @Context HttpServletRequest request) throws ConversationNotFoundException, SessionElevationRequiredException {
        this.elevatedSessionService.checkElevatedSession(ActionType.UNLOCK_USER_2SV_SETTINGS, request);
        TotpUserEnrollment enrollment = this.enrollmentService.completeVoluntaryEnrollment(verificationRequest.getConversationId(), verificationRequest.getTotpCode());
        log.debug("Completion of complete-voluntary-enrollment for user-key {} completed", (Object)enrollment.userKey());
        return new TotpRecoveryCodeDTO(enrollment.recoveryCode());
    }

    @Operation(description="Complete update of the authentication app used for two-step verification by verifying the provided TOTP code.", summary="Complete authentication app update for 2SV")
    @RequestBody(description="A request containing a TOTP code for the given user.", content={@Content(schema=@Schema(implementation=TotpCodeVerificationDTO.class))})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Authentication app successfully updated.", representation=TotpUserEnrollmentDTO.class), @ResponseDoc(responseCode=400, documentation="The requested authentication app conversation cannot be found or the user is not enrolled in two-step verification", restError=true), @ResponseDoc(responseCode=401, documentation="The currently authenticated user requires an elevated session to perform this request.", representation=ElevationMethodRestDTO.class)})
    @POST
    @Path(value="/complete-enrollment-update")
    public TotpRecoveryCodeDTO completeAuthenticationChange(TotpCodeVerificationDTO verificationRequest, @Context HttpServletRequest request) throws ConversationNotFoundException, SessionElevationRequiredException {
        this.elevatedSessionService.checkElevatedSession(ActionType.UNLOCK_USER_2SV_SETTINGS, request);
        TotpUserEnrollment enrollment = this.enrollmentService.completeChangeAuthenticationAppConversation(verificationRequest.getConversationId(), verificationRequest.getTotpCode());
        log.debug("Change authentication app for user-key {} completed", (Object)enrollment.userKey());
        return new TotpRecoveryCodeDTO(enrollment.recoveryCode());
    }

    private TotpUserEnrollmentDTO mapToTotpUserEnrollmentDTO(TotpEnrollConversation totpEnrollConversation) {
        Secret secret = this.encryptionService.unseal(Secret.of(totpEnrollConversation.getSealedSecret()));
        if (secret instanceof SealedSecret) {
            throw new DecryptionFailedException("Decryption failed while mapping conversation for user " + totpEnrollConversation.getUserName());
        }
        return new TotpUserEnrollmentDTO(totpEnrollConversation.getTotpURI(), Secret.rawValue(secret), totpEnrollConversation.getUserName(), totpEnrollConversation.getConversationId());
    }
}

