/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.rest;

import com.atlassian.annotations.security.UnlicensedSiteAccess;
import com.atlassian.dc.swagger.annotations.BasePathDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.authentication.api.tsv.internal.annotation.DisabledInLegacyMode;
import com.atlassian.plugins.authentication.tsv.exception.SessionElevationRequiredException;
import com.atlassian.plugins.authentication.tsv.model.ActionType;
import com.atlassian.plugins.authentication.tsv.model.ElevationMethodRestDTO;
import com.atlassian.plugins.authentication.tsv.model.TotpRecoveryCodeDTO;
import com.atlassian.plugins.authentication.tsv.service.ElevatedSessionService;
import com.atlassian.plugins.authentication.tsv.service.InternalRecoveryCodeService;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/totp/recovery-code")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@BasePathDoc(value="/tsv/latest")
@Tag(name="Authentication")
@DisabledInLegacyMode
@UnlicensedSiteAccess
public class RecoveryCodeResource {
    private static final Logger log = LoggerFactory.getLogger(RecoveryCodeResource.class);
    private final ElevatedSessionService elevatedSessionService;
    private final InternalRecoveryCodeService recoveryCodeService;
    private final UserManager userManager;
    private final I18nResolver i18nResolver;

    @Inject
    public RecoveryCodeResource(ElevatedSessionService elevatedSessionService, InternalRecoveryCodeService recoveryCodeService, UserManager userManager, I18nResolver i18nResolver) {
        this.elevatedSessionService = elevatedSessionService;
        this.recoveryCodeService = recoveryCodeService;
        this.userManager = userManager;
        this.i18nResolver = i18nResolver;
    }

    @Operation(description="Rotates the recovery code for the currently authentication user.", summary="Rotate recovery code")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="The recovery code has been successfully rotated.", representation=TotpRecoveryCodeDTO.class), @ResponseDoc(responseCode=400, documentation="The request has failed due to the user not being enrolled in two-step verification.", restError=true), @ResponseDoc(responseCode=401, documentation="The currently authenticated user requires an elevated session to perform this request.", representation=ElevationMethodRestDTO.class)})
    @POST
    @Path(value="/rotate")
    public TotpRecoveryCodeDTO rotateRecoverCode(@Context HttpServletRequest request) throws SessionElevationRequiredException {
        this.elevatedSessionService.checkElevatedSession(ActionType.UNLOCK_USER_2SV_SETTINGS, request);
        return Optional.ofNullable(this.userManager.getRemoteUser()).map(this::rotateUserRecoveryCode).map(TotpRecoveryCodeDTO::new).orElseThrow(() -> {
            log.debug("Failed to generate recovery code as user does not have an authenticated session");
            return new IllegalStateException(this.i18nResolver.getText("authentication.two-step-verification.unauthenticated.error.message"));
        });
    }

    private String rotateUserRecoveryCode(UserProfile userProfile) {
        return this.recoveryCodeService.rotateRecoveryCode(userProfile.getUserKey().getStringValue(), userProfile.getUsername());
    }
}

