/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.rest;

import com.atlassian.annotations.security.UnlicensedSiteAccess;
import com.atlassian.dc.swagger.annotations.BasePathDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.authentication.api.tsv.internal.annotation.DisabledInLegacyMode;
import com.atlassian.plugins.authentication.tsv.rest.model.SsoManagementStatusDTO;
import com.atlassian.plugins.authentication.tsv.service.SsoManagementStatusService;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.util.Optional;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/sso-management-status")
@BasePathDoc(value="/tsv/latest")
@Tag(name="Authentication")
@DisabledInLegacyMode
@UnlicensedSiteAccess
public class SsoManagementStatusResource {
    private final SsoManagementStatusService ssoManagementStatusService;
    private final UserManager userManager;
    private final I18nResolver i18nResolver;

    @Inject
    public SsoManagementStatusResource(SsoManagementStatusService ssoManagementStatusService, UserManager userManager, I18nResolver i18nResolver) {
        this.ssoManagementStatusService = ssoManagementStatusService;
        this.userManager = userManager;
        this.i18nResolver = i18nResolver;
    }

    @Operation(description="Retrieves the status of the SSO management for the currently authenticated user.", summary="Get SSO management status")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Successfully retrieved SSO management status", representation=SsoManagementStatusDTO.class), @ResponseDoc(responseCode=401, documentation="Failed to retrieve SSO management status due to unauthenticated user", restError=true)})
    @GET
    public SsoManagementStatusDTO getSsoManagementStatus(@Context HttpServletRequest request) {
        return Optional.ofNullable(this.userManager.getRemoteUser()).map(UserProfile::getUsername).map(username -> new SsoManagementStatusDTO(this.ssoManagementStatusService.isUserManagedBySsoProvider((String)username, request))).orElseThrow(() -> new IllegalStateException(this.i18nResolver.getText("authentication.two-step-verification.unauthenticated.error.message")));
    }
}

