/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.rest;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.annotations.security.UnlicensedSiteAccess;
import com.atlassian.dc.swagger.annotations.BasePathDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.authentication.api.tsv.internal.annotation.DisabledInLegacyMode;
import com.atlassian.plugins.authentication.common.rest.model.ErrorEntity;
import com.atlassian.plugins.authentication.tsv.exception.SessionElevationRequiredException;
import com.atlassian.plugins.authentication.tsv.model.ActionType;
import com.atlassian.plugins.authentication.tsv.model.ElevationMethodRestDTO;
import com.atlassian.plugins.authentication.tsv.model.TotpElevationRestDTO;
import com.atlassian.plugins.authentication.tsv.rest.AuthenticationResource;
import com.atlassian.plugins.authentication.tsv.service.ElevatedSessionService;
import com.atlassian.plugins.authentication.tsv.service.EnrollmentService;
import com.atlassian.plugins.authentication.tsv.service.InternalTotpService;
import com.atlassian.plugins.authentication.tsv.service.enforcement.EnforcementService;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/totp/unenroll")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@BasePathDoc(value="/tsv/latest")
@Tag(name="Authentication")
@DisabledInLegacyMode
public class UnenrollResource {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationResource.class);
    private final EnrollmentService enrollmentService;
    private final ElevatedSessionService elevatedSessionService;
    private final EnforcementService enforcementService;
    private final UserManager userManager;
    private final I18nResolver i18nResolver;
    private final InternalTotpService totpService;

    @Inject
    public UnenrollResource(EnrollmentService enrollmentService, ElevatedSessionService elevatedSessionService, EnforcementService enforcementService, UserManager userManager, I18nResolver i18nResolver, InternalTotpService totpService) {
        this.enrollmentService = enrollmentService;
        this.elevatedSessionService = elevatedSessionService;
        this.enforcementService = enforcementService;
        this.userManager = userManager;
        this.i18nResolver = i18nResolver;
        this.totpService = totpService;
    }

    @Operation(description="Unenroll the currently authenticated user from two-step verification.", summary="Uneroll current user from two-step verification")
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="User successfully unenrolled from two-step verification."), @ResponseDoc(responseCode=400, documentation="No enrollment found for the currently authenticated user.", restError=true), @ResponseDoc(responseCode=401, documentation="The currently authenticated user requires an elevated session to perform this request.", representation=ElevationMethodRestDTO.class)})
    @DELETE
    @UnlicensedSiteAccess
    public Response unenroll(@Context HttpServletRequest request, @Context HttpServletResponse response) throws SessionElevationRequiredException {
        this.elevatedSessionService.checkElevatedSession(ActionType.UNLOCK_USER_2SV_SETTINGS, request);
        UserKey remoteUserKey = this.userManager.getRemoteUserKey();
        if (this.enforcementService.isEnforcementRequired(remoteUserKey)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorEntity(this.i18nResolver.getText("authentication.two-step-verification.unenroll.forbidden.enforced.user"))).build();
        }
        return Optional.ofNullable(remoteUserKey).map(userKey -> this.handleUnenroll((UserKey)userKey)).map(rsp -> this.removeElevatedSession((Response)rsp, request, response)).orElseThrow(() -> new IllegalStateException(this.i18nResolver.getText("authentication.two-step-verification.unauthenticated.error.message")));
    }

    @Operation(description="Unenroll a user from two-step verification specified by the given username.", summary="Unenroll specific user from two-step verification")
    @Parameters(value={@Parameter(description="username", in=ParameterIn.PATH, name="userName")})
    @RequestBody(description="A request containing a TOTP code for the given user.", content={@Content(schema=@Schema(implementation=TotpElevationRestDTO.class))})
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="User successfully unenrolled from two-step verification."), @ResponseDoc(responseCode=400, documentation="No enrollment found for the specified user.", restError=true), @ResponseDoc(responseCode=401, documentation="The user has entered an invalid TOTP code.", restError=true), @ResponseDoc(responseCode=403, documentation="The user cannot unenroll themselves.", restError=true), @ResponseDoc(responseCode=404, documentation="No user matches the supplied <strong>username</strong>.", restError=true)})
    @SystemAdminOnly
    @DELETE
    @Path(value="/user/{userName}")
    public Response unenrollUser(@PathParam(value="userName") String userName, TotpElevationRestDTO totpElevationRestDTO) {
        UserKey userKey = Optional.ofNullable(this.userManager.getRemoteUserKey()).orElseThrow(() -> new IllegalArgumentException(this.i18nResolver.getText("authentication.two-step-verification.unauthenticated.error.message")));
        if (!this.totpService.isTotpCodeValid(userKey.getStringValue(), totpElevationRestDTO.getTotpCode())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)new ErrorEntity(this.i18nResolver.getText("authentication.two-step-verification.totp.error.message"))).build();
        }
        return Optional.ofNullable(this.userManager.getUserProfile(userName)).map(UserProfile::getUserKey).map(uk -> {
            if (userKey.equals(uk)) {
                LOG.debug("Self unenrollment is forbidden for user: {}", (Object)userName);
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorEntity(this.i18nResolver.getText("authentication.two-step-verification.unenroll.forbidden"))).build();
            }
            return this.handleUnenroll((UserKey)uk);
        }).orElseGet(() -> {
            LOG.debug("Following user name was not found: {}", (Object)userName);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorEntity(this.i18nResolver.getText("authentication.two-step-verification.unenroll.no.user"))).build();
        });
    }

    private Response removeElevatedSession(Response rsp, HttpServletRequest request, HttpServletResponse response) {
        this.elevatedSessionService.removeElevatedSession(response, request.getSession(false));
        return rsp;
    }

    private Response handleUnenroll(UserKey userKey) {
        LOG.debug("Removing enrollment for user: {}", (Object)userKey.getStringValue());
        if (!this.enrollmentService.removeTotpUserEnrollmentForUser(userKey.getStringValue())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorEntity(this.i18nResolver.getText("authentication.two-step-verification.unenroll.error"))).build();
        }
        LOG.debug("Enrollment removed for user: {}", (Object)userKey.getStringValue());
        return Response.noContent().build();
    }
}

