/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.rest.exception;

import com.atlassian.plugins.authentication.tsv.exception.LoginFormNotApplicableException;
import com.atlassian.plugins.authentication.tsv.rest.model.CredentialsCheckFailedDTO;
import com.atlassian.sal.api.message.I18nResolver;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.io.Serializable;

@Provider
public class LoginFormNotApplicableExceptionMapper
implements ExceptionMapper<LoginFormNotApplicableException> {
    private final I18nResolver i18nResolver;

    @Inject
    public LoginFormNotApplicableExceptionMapper(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public Response toResponse(LoginFormNotApplicableException exception) {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)new CredentialsCheckFailedDTO(this.i18nResolver.getText("authentication.login.failed.non.applicable.option", new Serializable[]{"<a href=\"" + exception.getAlternativeLoginPageUrl() + "\">", "</a>"}), false, false)).build();
    }
}

